function [basis, basis_parm] = vb_job_leadfield_meg_bem(proj_root, basis_parm)
% actual worker function for MEG-BEM
% [usage]
%   [basis, basis_parm] = vb_job_leadfield_meg_bem(proj_root, basis_parm)
% [input]
%    proj_root : <required> project root directory
%   basis_parm : <required> <<struct>>
%              :  data set in which the specification of calculation is defined
% [output]
%   none
% [note]
%   <<prior conditions>>
%     1) proj_root is valid
%     2) basis_parm is commonly valid
% [history]
%   2007-01-29 (Sako) initial version
%
% Copyright (C) 2011, ATR All Rights Reserved.
% License : New BSD License(see VBMEG_LICENSE.txt)

% --- CHECK ARGUMENTS --- %
[proj_root, basis_parm, headfile] = inner_check_arguments(proj_root, basis_parm);

% --- MAIN PROCEDURE --------------------------------------------------------- %
%
% pre-processing
[Basis_mode, pick, Qpick, Wsensor, V0, V, xx] = ...
  vb_lf_preprocess(proj_root, basis_parm);

% Calculate current direction according to 'Basis_mode'
[V,xx] = vb_current_vector(V, xx, Basis_mode);

% Prepare BEM parameter and calculate solid angle matrix

% load head file - be loaded Vhead, Fhead ... etc.
load([headfile]);
fprintf('# of vertices = %d\n',size(Vhead,1));
	
if  ~exist('Omega','var') | basis_parm.Recalc == ON,
  tic;
  fprintf('--- Solid angle calculation ');
	
  % 境界面係数行列計算
  % (Normal vectors (XXhead) are outwarded here)
  [Omega, Sout]= vb_solid_angle_grk(Vhead,Fhead,XXhead);
	
  fprintf('%f[sec]\n',toc);
  vb_save([headfile],'Omega','Sout');
end
	
fprintf('--- MEG BEM-linear-Galerkin ');

BB = vb_bem_meg(Omega, Sout, Vhead, Fhead, V, xx, pick, Qpick);
	
basis = Wsensor * BB;
basis = basis';
%
% --- END OF MAIN PROCEDURE -------------------------------------------------- %


% --- INNER FUNCTIONS -------------------------------------------------------- %
%
function [proj_root, basis_parm, head_file] = ...
  inner_check_arguments(proj_root, basis_parm)
if ~isfield(basis_parm, 'head_file')
  error('head_file is a required field of basis_parm');
end

head_file = fullfile(proj_root, basis_parm.head_file);
if exist(head_file, 'file') ~= 2
  error('cannot read head_file : %s', head_file);
end

% if you have other check points, you can do them here ...
return;
%
% --- END OF INNER FUNCTIONS ------------------------------------------------- %

%%% END OF FILE %%%
