function [basis, basis_parm] = vb_job_leadfield_eeg_sphere(proj_root, basis_parm)
% actual worker function for EEG SARVAS
% [usage]
%   [basis, basis_parm] = vb_job_leadfield_eeg_sphere(proj_root, basis_parm)
% [input]
%    proj_root : <required> project root directory
%   basis_parm : <required> <<struct>>
%              :  data set in which the specification of calculation is defined
% [output]
%   none
% [note]
%   <<prior conditions>>
%     1) proj_root is valid
%     2) basis_parm is commonly valid
% [history]
%   2007-01-29 (Sako) initial version
%   2007-06-15 (M. Sato) added check_eeg_radius
%
% Copyright (C) 2011, ATR All Rights Reserved.
% License : New BSD License(see VBMEG_LICENSE.txt)

% --- CHECK ARGUMENTS --- %
[proj_root, basis_parm] = inner_check_arguments(proj_root, basis_parm);

% --- MAIN PROCEDURE --------------------------------------------------------- %
%
% pre-processing
[Basis_mode, pick, Qpick, Wsensor, V0, V, xx] = ...
  vb_lf_preprocess(proj_root, basis_parm);

pick = [pick(:,1)-V0(1), pick(:,2)-V0(2), pick(:,3)-V0(3)];
V    = [   V(:,1)-V0(1),    V(:,2)-V0(2),    V(:,3)-V0(3)];

%basis_parm = vb_util_check_head_shell_info(proj_root, basis_parm);    

% Calculate current direction according to 'Basis_mode'
[V,xx] = vb_current_vector(V, xx, Basis_mode);

% R    : Relative radii of sphere from innermost to outermost
% sigma: Conductivity  from innermost to outermost
BEM.R     = basis_parm.radius;
BEM.sigma = basis_parm.sigma;

% EEG 3-shell Sphere model

[pick, R] = vb_calc_consistent_eeg_radius(V, pick, BEM.R);

fprintf('--- EEG potential (Sphere model) \n');
fprintf('--- Head radius = %f  \n', R);

% Electric potential
basis = vb_eeg_legendre(V, xx, pick, R, BEM.sigma);
%
% --- END OF MAIN PROCEDURE -------------------------------------------------- %


% --- INNER FUNCTIONS -------------------------------------------------------- %
%
function [proj_root, basis_parm] = inner_check_arguments(proj_root, basis_parm)

% if you have some check points, you can do them here ...

return;
%
% --- END OF INNER FUNCTIONS ------------------------------------------------- %
%%% END OF FILE %%%
