function  B_dipole = vb_spherical_harmo_magnetic_field( Xdipole, Qdipole, N, Rmax, Xmeg, Qmeg, A )
% calculate magnetic field of spherical harmonics
% [usage]
%   B_dipole = vb_spherical_harmo_magnetic_field( Xdipole, Qdipole, N, Rmax, Xmeg, Qmeg, A )
% [input]
%   Xdipole : coordinates of dipole current (NP x 3) NP: Number of Dipole
%   Qdipole : normal vectors of dipole current (NP x 3)
%       N : order of spherical function
%    Rmax : radius of spherical function
%    Xmeg : coordinates of sensor (Nmeg) Nmeg: Number of MEG sensor
%    Qmeg : orientations of sensor (Nmeg)
%       A : spherical  harmonic coefficient
% [output]
%  B_dipole : magnetic field of dipole current at Xdipole
%           : observed at sensor Xmeg (NP x Nmeg)
% [note]
% 
% [history]
%   2006.07.06 (Sako) initial version
%
% Copyright (C) 2011, ATR All Rights Reserved.
% License : New BSD License(see VBMEG_LICENSE.txt)

% spherical harmonics at Xdipole
YG = vb_spherical_grad(Xdipole, Qdipole, N, Rmax, 'f');

% magnetic field at sensor Xmeg produced by a current at Xdipole
B_dipole = vb_multi_sarvas(Xdipole,Qdipole,Xmeg,Qmeg);

B_dipole = B_dipole - YG * A;

return;
