function [grad, Itbl, Dim] = vb_spherical_grad_G(X, Q, N, Rmax)
% spherical harmonics gradient G external current
% [usage]
%   [grad, ltbl, Dim] = vb_spherical_grad_G(X, Q, N, Rmax)
% [input]
%      X : coordinates of external current (NP x 3)
%      Q : normal vector of external current (NP x 3)
%      N : maximum order of spherical function
%   Rmax : radial
% [output]
%   grad : gradient G
%   ltbl : legendre index table
%    Dim : dimension
% [note]
%  
% [history]
%   2006.06.30 (Sako) initial version
%
%
% Copyright (C) 2011, ATR All Rights Reserved.
% License : New BSD License(see VBMEG_LICENSE.txt)

% (N+1) order is necessary
[G, Itbl, dim, Rmax] = vb_spherical_harmo_G(X,N+1,Rmax);

NP = size(G,1);
D  = (N+1)^2;

V1 = zeros(NP,1);
V2 = zeros(NP,1);

grad = zeros(NP,D);

for n = 0:N
  for m = 0:n
      
    n_idx = n + 1;
    m_idx = m + 1;
      
    if n_idx < 1 | n_idx > size(Itbl,1) | m_idx < 1 | m_idx > size(Itbl,2)
      continue;
    end

    % cosine zone
    column_num = Itbl(n_idx,m_idx,1);
    if column_num < 1, continue; end;

    % X
    [V1, valid1] = vb_spherical_harmo_V(n,m,G,Itbl,'+',0);
    [V2, valid2] = vb_spherical_harmo_V(n,m,G,Itbl,'-',0);
    x = 0.5 * (V1 + V2);
        
    % Y
    [V1, valid1] = vb_spherical_harmo_V(n,m,G,Itbl,'+',1);
    [V2, valid2] = vb_spherical_harmo_V(n,m,G,Itbl,'-',1);
    y = 0.5 * (V1 - V2);

    % Z
    [V1, valid] = vb_spherical_harmo_V(n,m,G,Itbl,'0',0);
    z = V1;

    grad(:,column_num) = x .* Q(:,1) + y .* Q(:,2) + z .* Q(:,3);

    % sine zone
    column_num = Itbl(n_idx,m_idx,2);
    if column_num < 1, continue; end;
      
    % X
    [V1, valid1] = vb_spherical_harmo_V(n,m,G,Itbl,'+',1);
    [V2, valid2] = vb_spherical_harmo_V(n,m,G,Itbl,'-',1);
    x = 0.5 * (V1 + V2);

    % Y
    [V1, valid1] = vb_spherical_harmo_V(n,m,G,Itbl,'+',0);
    [V2, valid2] = vb_spherical_harmo_V(n,m,G,Itbl,'-',0);
    y = 0.5 * (V2 - V1);

    % Z
    [V1, valid] = vb_spherical_harmo_V(n,m,G,Itbl,'0',1);
    z = V1;

    grad(:,column_num) = x .* Q(:,1) + y .* Q(:,2) + z .* Q(:,3);
  
  end
end

%grad = grad(:,2:D);
%Itbl = Itbl(1:N+1,1:N+1,:) - 1;
%Dim  = dim(:,2:D);
Itbl = Itbl(1:N+1,1:N+1,:);
Dim  = dim(:,1:D);
return;
