function  omega_file = vb_util_make_omega_file(head_file, Omega, Sout)
% Make omega file which extension is '.omega.mat'. The omega file is one of head_files which is added Omega
% [usage]
%   omega_file = vb_util_make_omega_file(head_file, Omega, Sout)
% [input]
%    head_file : [required] base file which will be added 'Omega' and 'Sout'
%        Omega : [required] Omega data of vb_solid_angle_grk()
%         Sout : [required] Sout data of vb_solid_angle_grk()
% [output]
%   omega_file : new file name
% [note]
%   @see vb_util_get_file_body(), vb_save()
% [history]
%   2006-12-11 (Sako) initial version
%
% Copyright (C) 2011, ATR All Rights Reserved.
% License : New BSD License(see VBMEG_LICENSE.txt)

% check arguments
if ~exist('head_file', 'var') || isempty(head_file)
  error('head_file is a required parameter');
end

if exist(head_file, 'file') ~= 2
  error('cannot find head_file : %s', head_file);
end

if ~exist('Omega', 'var') || isempty(Omega)
  error('Omega is a required parameter');
end

if ~exist('Sout', 'var') || isempty(Sout)
  error('Sout is a required parameter');
end

% make file path
OMEGA_EXT = '.omega.mat';
fdir = fileparts(head_file);
omega_file = [fdir filesep vb_util_get_file_body(head_file) OMEGA_EXT];

% store
copyfile(head_file, omega_file);
vb_save([omega_file],'Omega','Sout');

%%% END OF FILE %%%
