function Headinfo = vb_headinfo_set_layertag(headinfo, layer_tag)
% setter Headinfo.LayerTag
% [usage]
%   Headinfo = headinfo_set_layer_tag(headinfo, layer_tag)
% [input]
%    headinfo : <optinal> <<struct>> Headinfo
%             :  if it is not specified or is empty, Headinfo will be created
%   layer_tag : <optional> value of LayerTag
%             :  if it is not specified or is empty, [] will be set
% [output]
%    Headinfo : <<struct>> updated Headinfo
% [note]
%
% [history]
%   2007-04-06 (Sako) initial version
%
% Copyright (C) 2011, ATR All Rights Reserved.
% License : New BSD License(see VBMEG_LICENSE.txt)

% --- CHECK ARGUMENTS --- %
if ~exist('headinfo', 'var') headinfo = []; end;
if ~exist('layer_tag', 'var')    layer_tag = []; end;
[Headinfo, layer_tag] = inner_check_arguments(headinfo, layer_tag);

% --- MAIN PROCEDURE --------------------------------------------------------- %
%
Headinfo.LayerTag = layer_tag;
if nargout ~= 1
  error('!!! You must receive updated Headinfo !!!');
end
%
% --- END OF MAIN PROCEDURE -------------------------------------------------- %

% --- INNER FUNCTIONS -------------------------------------------------------- %
%
% --- inner_check_arguments()
%
function [headinfo, layer_tag] = inner_check_arguments(headinfo, layer_tag)
% especially do nothing
return;
%
% --- end of inner_check_arguments()

%%% END OF FILE %%%
