function	[D] = vb_bem_matrix(D,BEM)
% multiply solid angle matrix by conductivity coefficient
%  [D] = vb_bem_matrix(D,BEM)
% D    : Solid angle matrix for boundary surfaces [Nvertex x Nvertex]
%
% BEM.sigma 	= conductivity for each layer, ΰƳΨ 
%               = [sigma(1), ..., sigma(Nsurf), 0]
% BEM.Nvertex   = # of vertex for each layer, ƶ̤ĺ
%               = [ start_id(1)     end_id(1)     ; 
%                             ...                 ;
%                   start_id(Nsurf) end_id(Nsurf) ]
%               = [ϥǥå, λǥå]
%
% ¿ض̥ǥˤ붭̷󡡤
%
% D    : ĺ (ŤդΩγ)
% Keeg : Conductivity coefficient for multi surface model
% Keeg : ݥƥ󥷥(EEG) ׻
% Kmeg : (MEG) ׻
%
% 2004-12-26 M. Sato
% 2007-06-18 M. Sato supported single layer head
% 2008-10-8  M. Sato calculation of 'Keeg' is moved to vb_bem_inverse_eeg
%
% Copyright (C) 2011, ATR All Rights Reserved.
% License : New BSD License(see VBMEG_LICENSE.txt)

NV		= size(D,1);		% ѷĺο
% Keeg  = ones(1,NV);		% EEG ݥƥ󥷥 ׻
% Kmeg  = ones(1,NV);  		% MEG  ׻

if nargin < 2,   return; end;
if isempty(BEM), return; end;

% ¿إǥξ硧ƳΨˤ

Nvertex = BEM.Nvertex;		% ƶ̤ĺ
Nsurf	= size(Nvertex,1);	% ̤ο
sigma	= BEM.sigma  ;		% ΰƳΨ

if Nsurf == 1, return; end;
if length(sigma)== Nsurf, sigma = [sigma(:); 0]; end;

% ̤˴ؤ롼
for i=1:Nsurf,
	ix = Nvertex(i,1):Nvertex(i,2);
	
	for j=1:Nsurf,
		jx = Nvertex(j,1):Nvertex(j,2);
		
		D(ix,jx) = D(ix,jx) ...
		         * ((sigma(j) - sigma(j+1))/(sigma(i) + sigma(i+1)));
	end;
	
	% ݥƥ󥷥뷸
%	Keeg(ix) = sigma(1)/(sigma(i) + sigma(i+1));
%	Keeg(ix) = 2*sigma(2)/(sigma(i) + sigma(i+1));
	
	% 췸
%	Kmeg(ix) = (sigma(i) - sigma(i+1));
	
end;

return
