function vb_job_normal_stat(proj_root,brain_parm)
% Calculate normal statics of original BV brain and make reduced model
%   vb_job_normal_stat(proj_root,brain_parm);
%
% Copyright (C) 2011, ATR All Rights Reserved.
% License : New BSD License(see VBMEG_LICENSE.txt)

proj_root = vb_rm_trailing_slash(proj_root);

area_file   = [proj_root '/' brain_parm.area_file];

brain_name  = brain_parm.brain_file;
reduce_name = vb_change_file_basename(brain_name, '_reduce');
brain_file  = [proj_root '/' brain_name];
reduce_file = [proj_root '/' reduce_name];

%
% --- Find original vertex near the cortical vertex
%
load(brain_file, 'BV_index');
normal_stat = vb_original_normal_statics(proj_root,brain_parm,BV_index);

fprintf('Save neighbor statics in the original brain\n')
vb_save(brain_file,'normal_stat')

%
% --- Make reduced cortex without corpus region
%
if ~exist([reduce_file],'file')
	vb_job_reduced_cortex(proj_root,brain_parm);
end
%
% Make inflate data.
%

area_key = 'reduced_cortex';
Area  = vb_get_area(area_file, area_key);

if ~isempty(Area),
	Vindx = Area.Iextract;
	
	load([brain_file],'Vinflate','inf_C');
	
	Vinflate = Vinflate(Vindx,:);
	inf_C    = inf_C(Vindx,:);

	fprintf(['--- Save brain model \n']);
	fprintf('     file = %s\n', reduce_file );
	
	vb_save(reduce_file,'Vinflate','inf_C');
	
	% Plot Inflate model
	brain_parm.brain_file = reduce_name;
	vb_check_inflate_model(proj_root,brain_parm);
end

