function vb_job_leadfield_old(proj_root,basis_parm)
% Make leadfield
%  vb_job_leadfield_old(proj_root,basis_parm)
%
% Copyright (C) 2011, ATR All Rights Reserved.
% License : New BSD License(see VBMEG_LICENSE.txt)

%
% Do not modify following lines
%
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
%
% make leadfield

global vbmeg_inst;
const = vbmeg_inst.const;

%%% necessary to confirm specification %%%
if ~exist('proj_root','var')
  % error
  error( 'argument : ''proj_root'' is required');
end

if ~exist('basis_parm','var')
  % error
  error( 'argument : ''basis_parm'' is required');
end

% Output file path
basis_file = [proj_root filesep basis_parm.basis_file];

basis_parm.proj_root = proj_root;

%
% Prepare leadfield calculation
%
[V, xx, pick, Qpick, Wsensor, BEM, Vhead, Fhead, Omega, Sout, SPHinfo] = ...
         vb_prepare_lead_field(basis_parm);

%
% Leadfield calculation
%
basis = vb_calc_lead_field(V, xx, pick, Qpick, Wsensor, ...
             basis_parm.bem_mode, BEM, Vhead, Fhead, Omega, Sout, SPHinfo);

% Print information
bem_name = { ...
	'MEG spherical model (Sarvas)'; ...
	'MEG BEM 1 shell model'; ...
	'MEG spherical harmonics expansion'; ...
	'EEG spherical 3 shell model'; ...
	'EEG BEM 3 shell model'; ...
};

fprintf('Leadfield calculation : %s\n',bem_name{basis_parm.bem_mode+1})
fprintf('Current direction = %d\n',basis_parm.Basis_mode)

if isfield(basis_parm, 'normal_mode') ...
   & basis_parm.normal_mode == const.NORMAL_NEIGHBOR_MEAN,
	fprintf('Normal vector is averaged over neighborhood\n')
end

fprintf('Save basis file [%s]\n',basis_file)

vb_save(basis_file,'basis','basis_parm');

% project_file save
proj_file = get_project_filename;
if isempty(proj_file)
    return;
end

project_file_mgr('load', proj_file);
project_file_mgr('add', 'basis_parm', basis_parm);

