function job_view_lf_update_sensorpattern(inst_id)
% Update contour map of lead field
%
% --- Syntax
% function job_view_lf_update_sensorpattern(inst_id)
%
% --- History
% 2009-01-26 Taku Yoshioka
%
% Copyright (C) 2011, ATR All Rights Reserved.
% License : New BSD License(see VBMEG_LICENSE.txt)

global vbmeg_inst;
if isempty(vbmeg_inst.viewlf{inst_id}.basisfile), return; end

%
% Global variables
%
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
h_fig = vbmeg_inst.viewlf{inst_id}.h_fig; 
h_sensor = vbmeg_inst.viewlf{inst_id}.h_sensor;
%h_cbar_sensor = vbmeg_inst.viewlf{inst_id}.h_cbar_sensor;
ix_selected_vertex = vbmeg_inst.viewlf{inst_id}.ix_selected_vertex;
cb4 = vbmeg_inst.viewlf{inst_id}.cb4; % 'fix_sensor_colorbar'
Bmin_plot = vbmeg_inst.viewlf{inst_id}.Bmin_plot;
Bmax_plot = vbmeg_inst.viewlf{inst_id}.Bmax_plot;
MEGinfo = vbmeg_inst.viewlf{inst_id}.MEGinfo;
pick = vbmeg_inst.viewlf{inst_id}.pick;
sensor_type = vbmeg_inst.viewlf{inst_id}.sensor_type;

%
% Select sensor
%
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
basis = vbmeg_inst.viewlf{inst_id}.basis_org_smoothed(:, ...
                                                  ix_selected_vertex);
if sensor_type~=-1, 
  ix1 = find(MEGinfo.ChannelInfo.Type==sensor_type);
  ix2 = find(vb_info_get_active_channel(MEGinfo,1)==true);
  ix = intersect(ix1,ix2);
  basis = basis(ix);
  pick = vbmeg_inst.viewlf{inst_id}.pick(ix,:);
end

%
% Draw contour map
%
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
% Scaling
if get(cb4,'Value')~=get(cb4,'Max'), 
  basis_max = max(abs(basis));
  Bmin_plot = -1*basis_max;
  Bmax_plot = 1*basis_max;
  vbmeg_inst.viewlf{inst_id}.Bmin_plot = Bmin_plot;
  vbmeg_inst.viewlf{inst_id}.Bmax_plot = Bmax_plot;
end
clim = [Bmin_plot Bmax_plot];

% Plot
set(h_fig,'CurrentAxes',h_sensor);
vb_plot_sensor_2d(pick(:,1:3),basis',clim);
axis off;
axis equal;
%axis tight;
colormap(jet);
%reset(h_cbar_sensor);
%colorbar(h_cbar_sensor);
colorbar;
