function err = job_view_cortex_list( action, target1, target2, selected )
% err = job_view_cortex_list( action, target1, target2, selected )
%
%  ꥹȤ롼 ( ꥹȤɲ, , ꥢ )
%
% action : 'add', 'delete', or 'clear'
% target1 : 'act' or 'area'
% target2 : 'candidate', 'plotted' or 'masking'
% selected : оݥꥹ򤵤줿ƥindex (֥Ȥľܼ)
%
%
% Copyright (C) 2011, ATR All Rights Reserved.
% License : New BSD License(see VBMEG_LICENSE.txt)


% оݥǡμ
H = get( gcf, 'UserData' );
data = get( getfield( H, [ target1 'data' ] ), 'UserData' );

switch action
  
 % ɲäξ --------------------------------------------------------
 case 'add'
  
  switch target2
   case 'plotted'
    added = setdiff( data.candidate(selected), data.plotted );
    if isempty( added ); err = 1; return; end;
    data.plotted = [ data.plotted, added ];
   case 'masking'
    added = setdiff( data.candidate(selected), data.masking );
    if isempty( added ); err = 1; return; end;
    data.masking = [ data.masking, added ];
  end


 % ξ --------------------------------------------------------
 case 'delete'

  switch target2
   case 'plotted'
    deleted = data.plotted( selected );
    if isempty( deleted ); err = 1; return; end;
    data.plotted = data.plotted( ~ismember( data.plotted, deleted ) );
   case 'masking'
    deleted = data.masking( selected );
    if isempty( deleted ); err = 1; return; end;
    data.masking = data.masking( ~ismember( data.masking, deleted ) );
   case 'candidate'
    if isempty( selected ); err = 1; return; end;
    if any( ismember( data.candidate(selected), data.plotted ) )
      data.plotted = data.plotted( ~ismember( data.plotted,...
					      data.candidate(selected) ) );
    end
    if isfield( data, 'masking' ) &...
	  any( ismember( data.candidate(selected), data.masking ) )
      data.masking = data.masking( ~ismember( data.masking,...
					      data.candidate(selected) ) );
    end
    data.candidate = data.candidate( ~ismember( data.candidate,...
						data.candidate(selected) ) );
  end


 % ꥢξ ------------------------------------------------------
 case 'clear'

  switch target2
   case 'plotted'
    data.plotted = [];
   case 'masking'
    data.masking = [];
  end

end


set( getfield( H, [ target1, 'data' ] ), 'UserData', data );

err = 0;
