function job_view_cortex_callback( key )
% job_view_cortex_callback
%
%  GUIIuWFNgcallbackďo
%  
%  * eIuWFNgɑ΂Ĉӂ key ƂČĂяo
%
%
% Copyright (C) 2011, ATR All Rights Reserved.
% License : New BSD License(see VBMEG_LICENSE.txt)

if ~strcmp( get( gcf, 'Tag'), 'job_view_cortex main' )
  return;
end

H = get( gcf, 'UserData' );

if isempty(H)
  return;
end

if isfield(H, 'fig')
  set( H.fig, 'Pointer', 'watch' );
end


switch key

 %%%%%%%%%%%%%%%%%%%%
 %%%  Brain Part  %%%
 %%%%%%%%%%%%%%%%%%%%

 %--------------------------------------------------------------------
 case 'brain load file button'
  err = job_view_cortex_file( 'load', 'brain', '' );
  if ~err
    job_view_cortex_aftereffect( 'file load brain' );
    job_view_cortex_plot( 'brain' );
  end


 %%%%%%%%%%%%%%%%%%%%%%%%%
 %%%  Activation Part  %%%
 %%%%%%%%%%%%%%%%%%%%%%%%%

 %--------------------------------------------------------------------
 case 'act load file button'
  err = job_view_cortex_file( 'load', 'act', '' );
  if ~err
    job_view_cortex_aftereffect( 'file load act' );
    job_view_cortex_plot( 'act' );
  end

 %--------------------------------------------------------------------
 case 'act list select'
  job_view_cortex_aftereffect( 'list act candidate select' );

 %--------------------------------------------------------------------
 case 'act plotted list select'
  job_view_cortex_aftereffect( 'list act plotted select' );
  job_view_cortex_plot( 'highlight act' );

 %--------------------------------------------------------------------
 case 'act add to plotted list button'
  selected = get( H.activation_list, 'Value' );
  err = job_view_cortex_list( 'add', 'act', 'plotted', selected );
  if ~err
    job_view_cortex_aftereffect( 'list act plotted add' );
    job_view_cortex_plot( 'act' );
  end

 %--------------------------------------------------------------------
 case 'act delete from plotted list button'
  selected = get( H.activation_plotted_list, 'Value' );
  err = job_view_cortex_list( 'delete', 'act', 'plotted', selected );
  if ~err
    job_view_cortex_aftereffect( 'list act plotted delete' );
    job_view_cortex_plot( 'act' );
  end

 %--------------------------------------------------------------------
 case 'act clear plotted list button'
  err = job_view_cortex_list( 'clear', 'act', 'plotted', [] );
  if ~err
    job_view_cortex_aftereffect( 'list act plotted delete' );
    job_view_cortex_plot( 'act' );
  end

  
 %%%%%%%%%%%%%%%%%%%
 %%%  Area Part  %%%
 %%%%%%%%%%%%%%%%%%%

 %--------------------------------------------------------------------
 case 'area load file button'
  err = job_view_cortex_file( 'load', 'area', '' );
  if ~err
    job_view_cortex_aftereffect( 'file load area' );
    job_view_cortex_plot( 'brain' );
  end

 %--------------------------------------------------------------------
 case 'area save file button'
  err = job_view_cortex_file( 'save', 'area', '' );
  if ~err
    job_view_cortex_aftereffect( 'file save area' );
  end

 %--------------------------------------------------------------------
 case 'area list select'
  job_view_cortex_aftereffect( 'list area candidate select' );
  
 %--------------------------------------------------------------------
 case 'area list delete button'
  data = get( H.areadata, 'UserData' );
  selected = get( H.area_list, 'Value' );
  keys = get( H.area_list, 'String' );
  delkey = []; for i = selected; delkey = [ delkey, ' ', keys{i} ]; end;
  deletep = questdlg( [ 'Are you sure to delete', delkey, '?' ] );
  if strcmp( deletep, 'Yes' )
    err = job_view_cortex_list( 'delete', 'area', 'candidate', selected );
    if ~err
      job_view_cortex_aftereffect( 'list area candidate delete' );
      job_view_cortex_plot( 'brain' );
    end
  end
  
 %--------------------------------------------------------------------
 case 'area plotted list select'
  job_view_cortex_aftereffect( 'list area plotted select' );
  job_view_cortex_plot( 'highlight area' );

 %--------------------------------------------------------------------
 case 'area masking list select'
  job_view_cortex_aftereffect( 'list area masking select' );

 %--------------------------------------------------------------------
 case 'area add to plotted list button'
  selected = get( H.area_list, 'Value' );
  err = job_view_cortex_list( 'add', 'area', 'plotted', selected );
  if ~err
    job_view_cortex_aftereffect( 'list area plotted add' );
    job_view_cortex_plot( 'area' );
  end

 %--------------------------------------------------------------------
 case 'area delete from plotted list button'
  selected = get( H.area_plotted_list, 'Value' );
  err = job_view_cortex_list( 'delete', 'area', 'plotted', selected );
  if ~err
    job_view_cortex_aftereffect( 'list area plotted delete' );
    job_view_cortex_plot( 'area' );
  end

 %--------------------------------------------------------------------
 case 'area clear plotted list button'
  err = job_view_cortex_list( 'clear', 'area', 'plotted', [] );
  if ~err
    job_view_cortex_aftereffect( 'list area plotted delete' );
    job_view_cortex_plot( 'area' );
  end

 %--------------------------------------------------------------------
 case 'area add to masking list button'
  selected = get( H.area_list, 'Value' );
  err = job_view_cortex_list( 'add', 'area', 'masking', selected );
  if ~err
    job_view_cortex_aftereffect( 'list area masking add' );
    job_view_cortex_plot( 'brain' );
  end

 %--------------------------------------------------------------------
 case 'area delete from masking list button'
  selected = get( H.area_masking_list, 'Value' );
  err = job_view_cortex_list( 'delete', 'area', 'masking', selected );
  if ~err
    job_view_cortex_aftereffect( 'list area masking delete' );
    job_view_cortex_plot( 'brain' );
  end

 %--------------------------------------------------------------------
 case 'area clear masking list button'
  err = job_view_cortex_list( 'clear', 'area', 'masking', [] );
  if ~err
    job_view_cortex_aftereffect( 'list area masking delete' );
    job_view_cortex_plot( 'brain' );
  end


 %%%%%%%%%%%%%%%%%%%%%%%%
 %%%  Selection Part  %%%
 %%%%%%%%%%%%%%%%%%%%%%%%

 %--------------------------------------------------------------------
 case 'selection add intersect act button'
  err = job_view_cortex_selection( 'add', 'act', 'intersect' );
  if ~err
    job_view_cortex_aftereffect( 'selection add' );
    job_view_cortex_plot( 'selection' );
  end

 %--------------------------------------------------------------------
 case 'selection delete intersect act button'
  err = job_view_cortex_selection( 'delete', 'act', 'intersect' );
  if ~err
    job_view_cortex_aftereffect( 'selection delete' );
    job_view_cortex_plot( 'selection' );
  end

 %--------------------------------------------------------------------
 case 'selection add union act button'
  err = job_view_cortex_selection( 'add', 'act', 'union' );
  if ~err
    job_view_cortex_aftereffect( 'selection add' );
    job_view_cortex_plot( 'selection' );
  end

 %--------------------------------------------------------------------
 case 'selection delete union act button'
  err = job_view_cortex_selection( 'delete', 'act', 'union' );
  if ~err
    job_view_cortex_aftereffect( 'selection delete' );
    job_view_cortex_plot( 'selection' );
  end

 %--------------------------------------------------------------------
 case 'selection add intersect area button'
  err = job_view_cortex_selection( 'add', 'area', 'intersect' );
  if ~err
    job_view_cortex_aftereffect( 'selection add' );
    job_view_cortex_plot( 'selection' );
  end

 %--------------------------------------------------------------------
 case 'selection delete intersect area button'
  err = job_view_cortex_selection( 'delete', 'area', 'intersect' );
  if ~err
    job_view_cortex_aftereffect( 'selection delete' );
    job_view_cortex_plot( 'selection' );
  end

 %--------------------------------------------------------------------
 case 'selection add union area button'
  err = job_view_cortex_selection( 'add', 'area', 'union' );
  if ~err
    job_view_cortex_aftereffect( 'selection add' );
    job_view_cortex_plot( 'selection' );
  end

 %--------------------------------------------------------------------
 case 'selection delete union area button'
  err = job_view_cortex_selection( 'delete', 'area', 'union' );
  if ~err
    job_view_cortex_aftereffect( 'selection delete' );
    job_view_cortex_plot( 'selection' );
  end
  
 %--------------------------------------------------------------------
 case 'selection undo button'
  err = job_view_cortex_selection( 'undo' );
  if ~err
    job_view_cortex_aftereffect( 'selection undo' );
    job_view_cortex_plot( 'selection' );
  end

 %--------------------------------------------------------------------
 case 'selection clear button'
  err = job_view_cortex_selection( 'clear' );
  if ~err
    job_view_cortex_aftereffect( 'selection delete' );
    job_view_cortex_plot( 'selection' );
  end

 %--------------------------------------------------------------------
 case 'selection dilation button'
  err = job_view_cortex_selection( 'add', 'dilation' );
  if ~err
    job_view_cortex_aftereffect( 'selection add' );
    job_view_cortex_plot( 'selection' );
  end

 %--------------------------------------------------------------------
 case 'selection erosion button'
  err = job_view_cortex_selection( 'delete', 'erosion' );
  if ~err
    job_view_cortex_aftereffect( 'selection delete' );
    job_view_cortex_plot( 'selection' );
  end
  
 %--------------------------------------------------------------------
 case 'selection register button'
  err = job_view_cortex_selection( 'register', 'area' );
  if ~err
    job_view_cortex_aftereffect( 'selection register' );
  end

 %--------------------------------------------------------------------
 case 'selection add mouse'
  err = job_view_cortex_selection( 'add', 'mouse' );
  if ~err
    job_view_cortex_aftereffect( 'selection add' );
    job_view_cortex_plot( 'selection' );
  end
  
 %--------------------------------------------------------------------
 case 'selection delete mouse'
  err = job_view_cortex_selection( 'delete', 'mouse' );
  if ~err
    job_view_cortex_aftereffect( 'selection delete' );
    job_view_cortex_plot( 'selection' );
  end



 %%%%%%%%%%%%%%%%%%%%%%%%%%%%%
 %%%  Mouse Function Part  %%%
 %%%%%%%%%%%%%%%%%%%%%%%%%%%%%

 %--------------------------------------------------------------------
 case 'mouse func'
  if get( H.mouse_func_radioZ, 'Value' ) == 1
    job_view_cortex_callback( 'mouse func Z' );
  end
  if get( H.mouse_func_radioR, 'Value' ) == 1
    job_view_cortex_callback( 'mouse func R' );
  end
  if get( H.mouse_func_radioS, 'Value' ) == 1
    job_view_cortex_callback( 'mouse func S' );
  end
  if get( H.mouse_func_radioU, 'Value' ) == 1
    job_view_cortex_callback( 'mouse func U' );
  end

 case 'mouse func Z'
  set( H.mouse_func_radioZ, 'Value', 1 );
  set( H.mouse_func_radioR, 'Value', 0 );
  set( H.mouse_func_radioS, 'Value', 0 );
  set( H.mouse_func_radioU, 'Value', 0 );
  zoom on;
  rotate3d off;
  set( findobj( H.plot_axes, 'Tag', 'brain' ), 'ButtonDownFcn', '' );
  if ~isempty(which('setAxes3DPanAndZoomStyle'))
      setAxes3DPanAndZoomStyle(zoom(H.plot_axes), H.plot_axes, 'camera')
      set(H.plot_axes, 'CameraViewAngleMode', 'auto');
  end

 case 'mouse func R'
  set( H.mouse_func_radioZ, 'Value', 0 );
  set( H.mouse_func_radioR, 'Value', 1 );
  set( H.mouse_func_radioS, 'Value', 0 );
  set( H.mouse_func_radioU, 'Value', 0 );
  zoom off;
  rotate3d on;
  set( findobj( H.plot_axes, 'Tag', 'brain' ), 'ButtonDownFcn', '' );

 case 'mouse func S'
  set( H.mouse_func_radioZ, 'Value', 0 );
  set( H.mouse_func_radioR, 'Value', 0 );
  set( H.mouse_func_radioS, 'Value', 1 );
  set( H.mouse_func_radioU, 'Value', 0 );
  zoom off;
  rotate3d off;
  set( findobj( H.plot_axes, 'Tag', 'brain' ), 'ButtonDownFcn',...
		    'job_view_cortex_callback(''selection add mouse'');' );

 case 'mouse func U'
  set( H.mouse_func_radioZ, 'Value', 0 );
  set( H.mouse_func_radioR, 'Value', 0 );
  set( H.mouse_func_radioS, 'Value', 0 );
  set( H.mouse_func_radioU, 'Value', 1 );
  zoom off;
  rotate3d off;
  set( findobj( H.plot_axes, 'Tag', 'brain' ), 'ButtonDownFcn',...
		    'job_view_cortex_callback(''selection delete mouse'');' );




 %%%%%%%%%%%%%%
 %%%  misc  %%%
 %%%%%%%%%%%%%%
 
 case 'list unselect'
  set( H.activation_plotted_list, 'Value', [] );
  set( H.area_plotted_list, 'Value', [] );
  set( H.area_masking_list, 'Value', [] );
  job_view_cortex_aftereffect( 'list act plotted unselect' );
  job_view_cortex_aftereffect( 'list area plotted unselect' );
  job_view_cortex_aftereffect( 'list area maksing unselect' );
  job_view_cortex_plot( 'highlight act' );
  job_view_cortex_plot( 'highlight area' );


 case 'print'
  h = figure;
  set(h, 'Units', 'normalized');
  ax_h = copyobj(H.plot_axes, h);
  set(ax_h, 'Units', 'normalized');
  set(ax_h, 'Position', [0.2, 0.11, 0.75, 0.85]);
  box off;
  axis equal;
  axis tight;
  set(h, 'Units', 'pixels');
  vb_epsfig(h,0.5,15);
  axis off;

  H.file_dialog.save_mode = 1;
  H.file_dialog.file_extensions = { '.eps' };
  [ pname fname ] = visible(H.file_dialog);
  if length(pname)
    print( h, '-depsc2', fullfile( pname, fname{1} ) );
  end
  delete(h);
 
 case 'close'
  closep = questdlg( 'Are you sure to close window ?', 'Close Window' );
  if strcmp( closep, 'Yes' );
    delete( H.fig );
  end
  
 case 'set param'
  param = get( H.paramdata, 'UserData' );
  param = job_view_cortex_param( param );
  if ~isempty(param)
    set( H.paramdata, 'UserData', param );
    job_view_cortex_aftereffect( 'param' );
    job_view_cortex_plot( 'brain' );
  end


 case 'mouse move'
  pntpos = get( 0, 'PointerLocation' );
  winpos = get( H.fig, 'Position' );
  axspos = get( H.plot_axes, 'Position' );
  pntpos = pntpos - winpos(1:2);
  if all( axspos(1:2) < pntpos & axspos(1:2) + axspos(3:4) > pntpos )
  else
    set( H.fig, 'Pointer', 'arrow' )
  end
  
  % adjust camera light position
  [a, e] = view(H.plot_axes);
  [ae] = get(H.plot_axes, 'UserData');
  if ~isequal([a, e], ae)
    axes_children = get(H.plot_axes, 'Children');
    for k=1:length(axes_children)
        if strcmp(get(axes_children(k),'Type'),'light'),
            light      = axes_children(k);
            light_num  = get(axes_children(k), 'UserData');
            if strcmpi(light_num, 'light1')
                camlight(light, 0, 0);
            elseif strcmpi(light_num, 'light2')
                camlight(light, 0, 180);
            end
        end
    end
  end
  set(H.plot_axes, 'UserData', [a, e]);
end

if ishandle( H.fig )
  set( H.fig, 'Pointer', 'arrow' );
end
