function [ix_time_from, ix_time_to, cancelled] = ...
    select_time_window(ix_origin, ix_range_from, ix_range_to, sampling_freq, ...
                        ix_initial_from, ix_initial_to)
% This function launches Time window application.
% Time Window can be specified in the millisecond by using this.
% 
% [IN]
%    ix_origin      : origin point(= 0msec)
%    ix_range_from  : Lower bound of index that can be specified.
%    ix_range_to    : Upper bound of index that can be specified.
%    sampling_freq  : sampling frequency
%    ix_inital_from : Initial Start point
%    ix_initial_to  : Initial End point
%
% [OUT]
%    ix_time_from   : Start point index
%    ix_time_to     : End   point index
%    cancelled      : GUI cancelled or not.
%                     = true  : CANCEL button or click x.
%                     = false : OK button pressed.
%
%
% Copyright (C) 2011, ATR All Rights Reserved.
% License : New BSD License(see VBMEG_LICENSE.txt)

% 
if ~exist('ix_initial_from', 'var')
    ix_initial_from = ix_range_from;
end

if ~exist('ix_initial_to', 'var')
    ix_initial_to = ix_range_to;
end

if ix_initial_from > ix_initial_to
    error('Time window range is invalid.');
end

% launch GUI application.
[ix_time_from, ix_time_to, cancelled] = ...
    select_time_window_gui('init', ...
                        ix_origin, ix_range_from, ix_range_to,...
                        sampling_freq, ...
                        ix_initial_from, ix_initial_to);
