function J = get_current_space(F,B)
%
% function J = get_current_space(F,B)
%
% Return the spacial distribution of the power of the estimated 
% current for the dipoles associated with the inverse filter. 
% 2004-05-31 Taku Yoshioka
%
% --- Input parameters
% F: Inverse filter, I-by-N (sparse) matrix. 
% B: MEG signal, N-by-T matrix. 
% 
% (I: number of dipoles)
% (N: number of sensors)
% (T: number of time steps)
%
% --- Output values
% J : Spacial distribution of the estimated current. 
%
%
% Copyright (C) 2011, ATR All Rights Reserved.
% License : New BSD License(see VBMEG_LICENSE.txt)

J = sum((F*(B*B')).*F,2);

