function job_plot_cmap_update_colorbarscale(inst_id)
% Update colorbar scale
% 
% [history]
% 2011-01-29 taku-y
% 2011-03-16 taku-y
%  [debug] Colorbar scale check is ignored when 'Fix' is checked on GUI.
%
% Copyright (C) 2011, ATR All Rights Reserved.
% License : New BSD License(see VBMEG_LICENSE.txt)

global vbmeg_inst; 

%
% Global variables
%
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
cb1            = vbmeg_inst.plotcmap{inst_id}.cb1; % fix_colorbar
cb6            = vbmeg_inst.plotcmap{inst_id}.cb6; % fix_colorbar_tf
cb7            = vbmeg_inst.plotcmap{inst_id}.cb7; % activity map cb
ed10           = vbmeg_inst.plotcmap{inst_id}.ed10; % Jmax_tf_plot_edit
lb1            = vbmeg_inst.plotcmap{inst_id}.ed10; % activity map lb
Jmax_plot_edit = vbmeg_inst.plotcmap{inst_id}.Jmax_plot_edit;
Jmin_plot_edit = vbmeg_inst.plotcmap{inst_id}.Jmin_plot_edit;
Jinfo          = vbmeg_inst.plotcmap{inst_id}.Jinfo;
TFinfo         = vbmeg_inst.plotcmap{inst_id}.TFinfo;
Jmax           = vbmeg_inst.plotcmap{inst_id}.Jmax;
TFmax          = vbmeg_inst.plotcmap{inst_id}.TFmax;
xxP            = vbmeg_inst.plotcmap{inst_id}.xxP;

%
% If released, update color scale edit boxes
%
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
if get(cb1,'Value')~=get(cb1,'Max'), 
  if ~isempty(xxP) && get(cb7,'Value'), 
    xxPmax = max(abs(xxP));
    set(Jmax_plot_edit,'String',num2str(xxPmax));
    set(Jmin_plot_edit,'String',num2str(0.1*xxPmax));
    job_plot_cmap_update_spatialpattern(inst_id);
  elseif ~isempty(Jinfo),
    set(Jmax_plot_edit,'String',num2str(Jmax));
    set(Jmin_plot_edit,'String',num2str(0.1*Jmax));
    job_plot_cmap_update_spatialpattern(inst_id);
  elseif ~isempty(TFinfo),
    set(Jmax_plot_edit,'String',num2str(TFmax));
    set(Jmin_plot_edit,'String',num2str(0.1*TFmax));
    job_plot_cmap_update_spatialpattern(inst_id);
  else
    set(Jmax_plot_edit,'String','');
    set(Jmin_plot_edit,'String','');
  end
end
%else
%  set(Jmax_plot_edit,'String','');
%  set(Jmin_plot_edit,'String','');
%end

if get(cb6,'Value')~=get(cb6,'Max'),
  if ~isempty(TFinfo),
    set(ed10,'String',num2str(TFmax));
    job_plot_cmap_update_timecourse(inst_id);
  end
end

return;
