function job_plot_cmap_update_camera(inst_id)
% Update camera position. 
% 
% This is invoked by job_plot_currentmap. 
%
% [syntax]
% job_plot_cmap_update_camera(inst_id)
%
% [history]
% 2011-03-14 taku-y
%
% Copyright (C) 2011, ATR All Rights Reserved.
% License : New BSD License(see VBMEG_LICENSE.txt)

global vbmeg_inst; 

%
% Global variables
%
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
h_space = vbmeg_inst.plotcmap{inst_id}.h_space;

%
% Change camera position
%
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
if ~isempty(h_space), 
  child2 = get(h_space,'Children');
  for j=1:length(child2)
    if strcmp(get(child2(j),'Type'),'light'),
      camlight(child2(j),'headlight');
      return;
    end
  end
end

return;