function job_plot_cmap_print_temporalpattern(inst_id)
% Print temporal pattern of brain activity. 
% 
% [syntax]
% job_plot_cmap_print_temporalpattern(inst_id)
%
% [history]
% ????-??-?? Taku Yoshioka
% 2008-09-01 Taku Yoshioka
% 2010-12-13 taku-y
%  [enhancement] Time-frequency data supported.
%  [internal change] Implamentation adapted from
%  job_plot_cmap_update_spatialpattern. 
% 2011-01-11 taku-y
%  [minor] inputdlg replaced by vb_property_dlg. 
% 2011-01-27 taku-y
%  [debug] Time-frequency window display for 'linear' scaling. 
% 2012-01-26 sako
%  [minor change] n_trial -> "n_trial" was replaced to "ix_trial"
% 2012-02-09 taku-y
%  [enhancement] Print option support.
%
% Copyright (C) 2011, ATR All Rights Reserved.
% License : New BSD License(see VBMEG_LICENSE.txt)

global vbmeg_inst; 
if isempty(vbmeg_inst.plotcmap{inst_id}.V), return; end

%
% Global variables
%
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
ix_trial   = vbmeg_inst.plotcmap{inst_id}.ix_trial;
Jinfo      = vbmeg_inst.plotcmap{inst_id}.Jinfo;
TFinfo     = vbmeg_inst.plotcmap{inst_id}.TFinfo;
TFmax      = vbmeg_inst.plotcmap{inst_id}.TFmax;
TFmin      = vbmeg_inst.plotcmap{inst_id}.TFmin;
toi        = vbmeg_inst.plotcmap{inst_id}.toi;
foi        = vbmeg_inst.plotcmap{inst_id}.foi;
ix_peak    = vbmeg_inst.plotcmap{inst_id}.ix_peak;
J_hold     = vbmeg_inst.plotcmap{inst_id}.J_hold; 
cb4        = vbmeg_inst.plotcmap{inst_id}.cb4;

if ~isempty(Jinfo), 
  Tmsec = Jinfo.Tmsec;
elseif ~isempty(TFinfo), 
  Tmsec = TFinfo.Tmsec;
else
  return;
end

% Vertex check
I = size(vbmeg_inst.plotcmap{inst_id}.V,1); 
ix_peak = ceil(ix_peak);
if ix_peak<1, ix_peak = 1; end;
if ix_peak>I, ix_peak = I; end; 
vbmeg_inst.plotcmap{inst_id}.ix_peak = ix_peak;

% Time window range check
if toi(1)<min(Tmsec), toi(1)=min(Tmsec); end
if toi(1)>max(Tmsec), toi(1)=max(Tmsec); end
if toi(2)<min(Tmsec), toi(2)=min(Tmsec); end
if toi(2)>max(Tmsec), toi(2)=max(Tmsec); end
if toi(1)>toi(2), toi=toi(2:-1:1); end
vbmeg_inst.plotcmap{inst_id}.toi = toi;

% Frequency window range check
if ~isempty(TFinfo),
  if foi(1)<min(TFinfo.freq), foi(1)=min(TFinfo.freq); end
  if foi(1)>max(TFinfo.freq), foi(1)=max(TFinfo.freq); end
  if foi(2)<min(TFinfo.freq), foi(2)=min(TFinfo.freq); end
  if foi(2)>max(TFinfo.freq), foi(2)=max(TFinfo.freq); end
  if foi(1)>foi(2), foi=foi(2:-1:1); end
  vbmeg_inst.plotcmap{inst_id}.foi = foi;
end

ixx = ix_peak;
W = vbmeg_inst.plotcmap{inst_id}.W(ixx,:);

% Calculate timecourse of brain acvitity in Region of Interest
if ~isempty(Jinfo), 
  if ixx==0, 
    J = zeros(length(Tmsec),1); 
  elseif isempty(J_hold), 
    ixx2 = find(sum(abs(W),1)>0);
    W = W(:,ixx2);
    if length(W(:))>0,
      if size(vbmeg_inst.plotcmap{inst_id}.Jact,3) > 1
        J = W*vbmeg_inst.plotcmap{inst_id}.Jact(ixx2,:,ix_trial)/sum(W(:));
      else
        J = W*vbmeg_inst.plotcmap{inst_id}.Jact(ixx2,:)/sum(W(:));
      end
    end

    J_hold = J;
  end
    
  % Ylabel of graph
  if Jinfo.patch_norm==ON, 
    ylabel_str = 'Dipole moment density [pAm/mm^2]';
  else
    ylabel_str = 'Dipole moment [nA\cdot m]';
  end
elseif ~isempty(TFinfo), 
  if ixx==0, 
    data = zeros(length(TFinfo.freq),length(Tmsec));
  else
    W = sparse(W*TFinfo.Wact);
    ixx = find(W>0);

    c = 0.0; % normalize constant
    data = zeros(length(TFinfo.freq),length(TFinfo.Tmsec));
    for i=1:length(ixx)
      data ...
          = data+W(ixx(i))*vbmeg_inst.plotcmap{inst_id}.data(:,:,ixx(i));
      c = c+W(ixx(i));
    end
    data = data./c;

    % Ylabel of graph
    ylabel_str = 'Frequency [Hz]';
  end
else
  return;
end

%
% Plot timecourse of brain activity
%
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
h = figure; 
if ~isempty(Jinfo),
  plot(repmat(Tmsec,[size(J_hold,1) 1])',J_hold');
  xlim([min(Tmsec) max(Tmsec)]);
  yy = ylim;
  set(gca,'YDir','normal');
  
  % Show dialog to input figure properties
  title_str = ['Vertex ' num2str(ix_peak)];
  property_names = {'Title','ylim','Print option'};
  default_values = {title_str,num2str(yy),'-depsc'};
  description ...
      = {'Figure title.', ...
         '[min max] of y axis.','Print option (such as ''-dpng'').'};
  values = vb_property_dlg(property_names,default_values,description);

  if isempty(values),
    close;
    return;
  end
  
  title_str = values{1};
  yy        = str2num(values{2});
  opt_print = values{3};
  
  set(gca,'YLim',yy);
else
  % Show dialog to input figure properties
  title_str = ['Vertex ' num2str(ix_peak)];
  property_names = {'Title','Colorbar','Time-frequency window','Max'};
  default_values = {title_str,'1','1',num2str(TFmax)};
  description ...
      = {'Colorbar is attached (=1) or not (0).', ...
         'Time-frequency window is shown (1) or not (0).' ...
         'Maximum value of the absolute value plotted.'};
  values = vb_property_dlg(property_names,default_values,description);

  if isempty(values),
    close;
    return;
  end
  
  title_str = values{1};
  iscbar    = str2num(values{2});
  istfbox   = str2num(values{3});
  TFmax     = str2num(values{4});

  if strcmp(TFinfo.freq_scale,'log'), 
    h_img = imagesc(TFinfo.Tmsec,log2(TFinfo.freq),data);
    ylim(log2([min(TFinfo.freq) max(TFinfo.freq)]));
    yy = [2 5 10 20 50 100 200 500 1000 2000 5000 10000];
    [tmp,ix_yy1] = find(yy<=max(TFinfo.freq));
    [tmp,ix_yy2] = find(yy>=min(TFinfo.freq));
    yy = sort(yy(intersect(ix_yy1,ix_yy2)));
    set(gca,'YDir','normal','YTick',log2(yy),'YTickLabel',yy);
  else
    h_img = imagesc(TFinfo.Tmsec,TFinfo.freq,data);
    ylim([min(TFinfo.freq) max(TFinfo.freq)]);
    set(gca,'YDir','normal');
    %yy = [2 5 10 20 50 100 200 500 1000 2000 5000 10000];
    %[tmp,ix_yy1] = find(yy<=max(TFinfo.freq));
    %[tmp,ix_yy2] = find(yy>=min(TFinfo.freq));
    %yy = sort(yy(intersect(ix_yy1,ix_yy2)));
    %set(gca,'YDir','normal','YTick',log2(yy),'YTickLabel',yy);
  end
  
  % Color range
  if TFmin<0,
    caxis(gca,[-1*TFmax TFmax]);
  else
    caxis(gca,[0 TFmax]);
  end
  
  % Time-frequency window
  if istfbox,
    
    xinf = toi(1);
    xsup = toi(2);
    if strcmp(TFinfo.freq_scale,'log'), 
      yinf = log2(foi(1));
      ysup = log2(foi(2));
    else
      yinf = foi(1);
      ysup = foi(2);
    end
    patch( [ xinf, xsup, xsup, xinf ],...
           [ yinf, yinf, ysup, ysup ], ...
           'k','FaceColor','none','LineWidth',2.5);
  end
  
  % Colorbar
  if iscbar,
    h_cbar_tf = colorbar;
    if TFmin<0, 
      set(h_cbar_tf,'Ylim',[-1*TFmax TFmax],'XTick',[]);
    else
      set(h_cbar_tf,'Ylim',[0 TFmax],'XTick',[]);
    end
  end
end

xlabel('Time [ms]');
ylabel(ylabel_str);

pos = get(gca,'Position');
set(gca,'Position',[pos(1) pos(2)+0.05 pos(3) pos(4)-0.1]);
title(title_str);

%
% Print figure
%
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
vb_epsfig(gcf,0.5,15);

if ~isempty(findstr(opt_print,'-dpng')), 
  [fig_dir,fig_file] = vb_file_select({'.png'},'Save figure',true);
else
  [fig_dir,fig_file] = vb_file_select({'.eps'},'Save figure',true);
end

if ~isempty(fig_file), 
  figfile = [fig_dir filesep fig_file{1}];
  print(h,opt_print,figfile);
end

delete(h);

return;
