function job_plot_cmap_load_current(inst_id,currfile,ix_trial,verbose)
% Load cortical current or time-frequency data. 
%
% [syntax]
% job_plot_cmap_load_current(inst_id,currfile,ix_trial,verbose)
%
% [history]
% 2008-09-01 Taku Yoshioka
% 2009-07-30 Taku Yoshioka
%  Multiple trial current data has been supported. 
% 2010-03-08 rhayashi
%  Read single trial data at a one time
%  when multiple trial current data is inputted
% 2010-12-01 taku-y
%  [internal change] 'Jinfo' replaces 'MEGinfo'.
% 2010-12-06 taku-y
%  [internal change] 'Jinfo' of version 0.9 or later preferentially
%  used. 
% 2010-12-08 taku-y
%  [internal change] vb_version_cmp used.
% 2010-12-11 taku-y
%  [enhancement] Time-frequency data supported. The filetype is
%  determined by file extention ('.curr.mat' or '.tf.mat'). 
% 2011-01-29 taku-y
%  [enhancement] Activity map plot supported. 
% 2011-02-02 taku-y
%  [minor] When loading cortical current it can be averaged (as do
%  job_plot_meg). 
% 2011-02-16 taku-y
%  [enhancement] Cortical area plot supported. 
% 2012-01-26 sako
%  [minor change] n_trial -> "n_trial" was replaced to "ix_trial"
% 2012-02-09 taku-y
%  [debug] Support for .curr.mat file including both Jinfo and MEGinfo
%  (old format)
%
% Copyright (C) 2011, ATR All Rights Reserved.
% License : New BSD License(see VBMEG_LICENSE.txt)

global vbmeg_inst; 

error('This function will become obsolete. (Feb 20 2012 taku-y)')

%
% Input parameters
%
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
if nargin<4, verbose = true; end
if nargin<3, ix_trial= 1; end

%
% Global variables
%
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
h_fig = vbmeg_inst.plotcmap{inst_id}.h_fig;
ed11  = vbmeg_inst.plotcmap{inst_id}.ed11;
ed12  = vbmeg_inst.plotcmap{inst_id}.ed12;

set(h_fig,'Pointer','watch');
drawnow;

%
% Load estimated current
%
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
if ~exist(currfile,'file'),
  warndlg(['File ' currfile ' does not exist.']);
  return;
end

drawnow;

if findstr(currfile,'.curr.mat'),  % Load cortical current file
  % Clear time-frequency variables
  vbmeg_inst.plotcmap{inst_id}.tffile     = [];
  vbmeg_inst.plotcmap{inst_id}.data       = [];
  vbmeg_inst.plotcmap{inst_id}.TFmax      = [];
  vbmeg_inst.plotcmap{inst_id}.TFmin      = [];
  vbmeg_inst.plotcmap{inst_id}.TFmax_plot = [];
  vbmeg_inst.plotcmap{inst_id}.TFmin_plot = [];
  vbmeg_inst.plotcmap{inst_id}.foi        = [];
  vbmeg_inst.plotcmap{inst_id}.TFinfo     = [];
  
  % Filename
  vbmeg_inst.plotcmap{inst_id}.currfile = currfile;
  
  % If cortical current file has multiple trials, ask if you load
  % averaged data or not. 
  Jinfo = vb_load_current_info(currfile);
  if Jinfo.Ntrial>1, 
    button = questdlg(['The specified cortical current file has ' ...
                       'multiple trials. Do you want to load' ...
                       'trial-average data or the original one?'], ...
                      'Load cortical current data','Average','Raw', ...
                      'Average');
    if strcmp(button,'Average'), 
      ave_mode = true;
    else
      ave_mode = false;
    end
  else
    ave_mode = true;
  end
  vbmeg_inst.plotcmap{inst_id}.ave_mode = ave_mode;

  % load current data
  [tmp,Jact] = vb_load_current(currfile,0,ave_mode,ix_trial);
  if ~isempty(vbmeg_inst.plotcmap{inst_id}.V), 
    if max(Jinfo.ix_act_ex)>size(vbmeg_inst.plotcmap{inst_id}.V,1), 
      warndlg(['Index of dipole currents exceeds the number of ' ...
               'vertices.']);
      return;
    end
  end

  % Dipole current direction is flipped to inward
  vbmeg_inst.plotcmap{inst_id}.Jact = -1*Jact;
  clear Jact;
  
  % plotcmap.ix_act was obsoleted
  if ~isfield(Jinfo,'version') || ...
        vb_version_cmp(Jinfo.version,'<','0.9-0.a.0'),
    if isfield(Jinfo,'ix_act_ex'), 
      vbmeg_inst.plotcmap{inst_id}.ix_act = Jinfo.ix_act_ex;
    else
      vbmeg_inst.plotcmap{inst_id}.ix_act = Jinfo.ix_act;
    end
  end

  % Background current is not supported. 
  vbmeg_inst.plotcmap{inst_id}.Jbck = [];
  vbmeg_inst.plotcmap{inst_id}.ix_bck = [];

  % Temporal information
  load(currfile,'bayes_parm','MEGinfo');
  
  if isfield(Jinfo,'version') & ...
        vb_version_cmp(Jinfo.version,'>=','0.9-0.a.0'), 
    T = Jinfo.Tmsec;
    vbmeg_inst.plotcmap{inst_id}.Jinfo = Jinfo;
  elseif exist('MEGinfo'), 
    T = (1000/MEGinfo.SampleFreq) ...
        *(Jinfo.Tsample-vb_meginfo_get_pre_trigger(MEGinfo));
    if exist('Jinfo'), 
      vbmeg_inst.plotcmap{inst_id}.Jinfo = Jinfo;
    else
      vbmeg_inst.plotcmap{inst_id}.Jinfo = MEGinfo;
    end
    %vbmeg_inst.plotcmap{inst_id}.Tmsec = T;
    vbmeg_inst.plotcmap{inst_id}.Jinfo.version = '0.7';
    vbmeg_inst.plotcmap{inst_id}.Tstart = Jinfo.Tsample(1);
  else
    T = Jinfo.Tmsec;
    %vbmeg_inst.plotcmap{inst_id}.Tmsec = T; 
    vbmeg_inst.plotcmap{inst_id}.Jinfo = Jinfo;
    vbmeg_inst.plotcmap{inst_id}.Jinfo.version = '0.7';
    vbmeg_inst.plotcmap{inst_id}.Tstart = Jinfo.Tsample(1);
  end

  vbmeg_inst.plotcmap{inst_id}.toi = [T(1) T(2)];

  % Other parameters
  if isfield(Jinfo,'patch_norm'), 
    patch_norm = Jinfo.patch_norm;
  elseif isfield(Jinfo,'bayes_parm') ...
        & isfield(Jinfo.bayes_parm,'patch_norm'), 
    patch_norm = Jinfo.bayes_parm.patch_norm
    vbmeg_inst.plotcmap{inst_id}.Jinfo.patch_norm ...
        = Jinfo.bayes_parm.patch_norm;
  elseif exist('bayes_parm'), 
    % following line will be deleted after checking function: 
    % vbmeg_inst.plotcmap{inst_id}.bayes_parm = bayes_parm;
    vbmeg_inst.plotcmap{inst_id}.Jinfo.patch_norm = ...
        bayes_parm.patch_norm;
    patch_norm = bayes_parm.patch_norm;
  else
    patch_norm = false;
  end

  if ~isempty(ix_trial)
    vbmeg_inst.plotcmap{inst_id}.ix_trial = ix_trial;
  else
    vbmeg_inst.plotcmap{inst_id}.ix_trial = 1;
  end
  set(vbmeg_inst.plotcmap{inst_id}.ed1,'String', ...
    num2str(vbmeg_inst.plotcmap{inst_id}.ix_trial));

  % Physical unit of current
  if patch_norm, % [pAm/mm^2]
    vbmeg_inst.plotcmap{inst_id}.Jact ...
        = vbmeg_inst.plotcmap{inst_id}.Jact*1e6; % (=1e12*1e-6);
    vbmeg_inst.plotcmap{inst_id}.Jbck ...
        = vbmeg_inst.plotcmap{inst_id}.Jbck*1e6; % (=1e12*1e-6);
    %set(vbmeg_inst.plotcmap{inst_id}.Jmin_unit_text,'String', ...
    %                  '[pAm/mm^2]');
    %set(vbmeg_inst.plotcmap{inst_id}.Jmax_unit_text,'String', ...
    %                  '[pAm/mm^2]');
  else                          % [nAm]
    vbmeg_inst.plotcmap{inst_id}.Jact ...
        = vbmeg_inst.plotcmap{inst_id}.Jact*1e9;
    vbmeg_inst.plotcmap{inst_id}.Jbck ...
        = vbmeg_inst.plotcmap{inst_id}.Jbck*1e9;
    %set(vbmeg_inst.plotcmap{inst_id}.Jmin_unit_text,'String', ...
    %                  '[nAm]');
    %set(vbmeg_inst.plotcmap{inst_id}.Jmax_unit_text,'String', ...
    %                  '[nAm]');
  end

  % Scale of current amplitude
  if size(vbmeg_inst.plotcmap{inst_id}.Jact,3) > 1
    ix_trial = vbmeg_inst.plotcmap{inst_id}.ix_trial;
    Jmax = max(max(abs(vbmeg_inst.plotcmap{inst_id}.Jact(:,:,ix_trial))));
    Jmin = min(min(abs(vbmeg_inst.plotcmap{inst_id}.Jact(:,:,ix_trial))));
  else
    Jmax = max(max(abs(vbmeg_inst.plotcmap{inst_id}.Jact(:,:))));
    Jmin = min(min(abs(vbmeg_inst.plotcmap{inst_id}.Jact(:,:))));
  end
  vbmeg_inst.plotcmap{inst_id}.Jmax = Jmax;
  vbmeg_inst.plotcmap{inst_id}.Jmin = Jmin;
  vbmeg_inst.plotcmap{inst_id}.Jmax_plot = Jmax;
  vbmeg_inst.plotcmap{inst_id}.Jmin_plot = Jmax*0.1;
  %set(vbmeg_inst.plotcmap{inst_id}.Jmax_plot_edit,'String',...
  %                  num2str(Jmax));
  %set(vbmeg_inst.plotcmap{inst_id}.Jmin_plot_edit,'String',...
  %                  num2str(0.1*Jmax));
  set(vbmeg_inst.plotcmap{inst_id}.ed10,'String','');
elseif findstr(currfile,'.tf.mat'), % Load time frequency file
  % Clear cortical current variables
  vbmeg_inst.plotcmap{inst_id}.currfile  = [];
  vbmeg_inst.plotcmap{inst_id}.data      = [];
  vbmeg_inst.plotcmap{inst_id}.Jmax      = [];
  vbmeg_inst.plotcmap{inst_id}.Jmin      = [];
  vbmeg_inst.plotcmap{inst_id}.Jmax_plot = [];
  vbmeg_inst.plotcmap{inst_id}.Jmin_plot = [];
  vbmeg_inst.plotcmap{inst_id}.foi       = [];
  vbmeg_inst.plotcmap{inst_id}.Jinfo     = [];
  
  % Filename
  vbmeg_inst.plotcmap{inst_id}.tffile = currfile;
  
  % Time-frequency data
  load(currfile,'data','TFinfo');
  if ~isfield(TFinfo,'freq_scale'), % TFinfo format under development
    TFinfo.freq_scale = 'log';
  end
  vbmeg_inst.plotcmap{inst_id}.data   = data;
  vbmeg_inst.plotcmap{inst_id}.TFinfo = TFinfo;
  clear data;
  
  % Plotting threshold
  TFmax = max(max(max(abs(vbmeg_inst.plotcmap{inst_id}.data))));
  TFmin = min(min(min(vbmeg_inst.plotcmap{inst_id}.data)));
  vbmeg_inst.plotcmap{inst_id}.TFmax      = TFmax;
  vbmeg_inst.plotcmap{inst_id}.TFmin      = TFmin;
  vbmeg_inst.plotcmap{inst_id}.TFmax_plot = TFmax;
  vbmeg_inst.plotcmap{inst_id}.TFmin_plot = 0.1*TFmax;
  %set(vbmeg_inst.plotcmap{inst_id}.Jmax_plot_edit,'String',...
  %                  num2str(TFmax));
  %set(vbmeg_inst.plotcmap{inst_id}.Jmin_plot_edit,'String',...
  %                  num2str(0.1*TFmax));
  set(vbmeg_inst.plotcmap{inst_id}.ed10,'String',...
                    num2str(TFmax));
  
  % Time-frequency information
  T = TFinfo.Tmsec;
  F = TFinfo.freq;
  vbmeg_inst.plotcmap{inst_id}.toi = [T(1) T(2)];
  vbmeg_inst.plotcmap{inst_id}.foi = [F(1) F(2)];
elseif findstr(currfile,'.act.mat'), % Load activity map file
  % Filename
  vbmeg_inst.plotcmap{inst_id}.act_file = currfile;
  
  % Update listbox
  keyset = vb_get_keyset_act(currfile);
  set(vbmeg_inst.plotcmap{inst_id}.lb1,'String',keyset);
  set(vbmeg_inst.plotcmap{inst_id}.lb1,'Value',1);
  
  % Update activity map
  job_plot_cmap_update_xxP(inst_id);
else % Load cortical area file
  % Filename
  vbmeg_inst.plotcmap{inst_id}.area_file = currfile;
  
  % Update listbox
  keyset = vb_get_keyset_area(currfile);
  set(vbmeg_inst.plotcmap{inst_id}.lb2,'String',keyset);
  set(vbmeg_inst.plotcmap{inst_id}.lb2,'Value',1);
  
  % Update cortical area
  job_plot_cmap_update_area(inst_id);
end

% Update edittext of color scaling
job_plot_cmap_update_colorbarscale(inst_id);

%
% Change figure title/act_file/area_file edit box
%
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
[tmp,fname,ext] = fileparts(currfile);
if ~isempty(findstr(currfile,'.curr.mat')) ...
      || ~isempty(findstr(currfile,'.tf.mat')), 
  set(h_fig,'Name',['job_plot_currentmap: ' fname ext]);
elseif findstr(currfile,'.act.mat'), 
  set(ed11,'String',[fname ext]);
else
  set(ed12,'String',[fname ext]);
end

%
% Load cortical surface model
%
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
if exist('bayes_parm'), 
  brainfile = bayes_parm.brainfile;
else
  brainfile = '';
end

% Check if a cortical surface model has been loaded
brainfile_old = vbmeg_inst.plotcmap{inst_id}.brainfile; 
if ~isempty(brainfile_old) & ~isempty(brainfile), 
  if verbose == true
    qstring = ['Cortical surface model ''' brainfile_old ' has already ' ...
               'been loaded. Do you replace this model by ' ...
               brainfile '?'];
    button = questdlg(qstring,'Overwrite cortical surface model',...
                        'Yes','No','Yes');
  else
    button = 'No';
  end
  
  if strcmp(button,'No'), 
    job_plot_cmap_update_filterradius(inst_id);
    job_plot_cmap_update_timecourse(inst_id); 
    job_plot_cmap_update_spatialpattern(inst_id);
    return;
  end
end
    
if exist(brainfile,'file'),   
  vbmeg_inst.plotcmap{inst_id}.brainfile = brainfile;
  
  % Cortical surface model
  [Vinf,F,xx,inf_C,xxA] = vb_load_cortex(brainfile,'Inflate');
  V = vb_load_cortex(brainfile);
  vbmeg_inst.plotcmap{inst_id}.V = V;
  vbmeg_inst.plotcmap{inst_id}.Vinf = Vinf;
  vbmeg_inst.plotcmap{inst_id}.F = F;
  vbmeg_inst.plotcmap{inst_id}.inf_C = inf_C;
  vbmeg_inst.plotcmap{inst_id}.xxA = xxA;

  % Standard brain coordinate
  load(brainfile,'Vtal','Vmni');
  if ~exist('Vtal','var'), Vtal = zeros(size(V)); end
  if ~exist('Vmni','var'), Vmni = zeros(size(V)); end
  vbmeg_inst.plotcmap{inst_id}.Vtal = Vtal*1e3;
  vbmeg_inst.plotcmap{inst_id}.Vmni = Vmni*1e3;

  % Load neighbour data for filter calculation
  [nextDD,nextIX] = vb_load_cortex_neighbour(brainfile); 
  vbmeg_inst.plotcmap{inst_id}.nextDD = nextDD;
  vbmeg_inst.plotcmap{inst_id}.nextIX = nextIX;
end;
%elseif verbose, 
%  warndlg(['File ''' brainfile ''' does not exist. You have to ' ...
%           'manually choose the cortical surface file ' ...
%           '(.brain.mat).']);
%  return;
%end

%
% Update plots
%
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
job_plot_cmap_update_filterradius(inst_id);
job_plot_cmap_update_timecourse(inst_id); 
job_plot_cmap_update_spatialpattern(inst_id);
set(h_fig,'Pointer','arrow');
