function J0 = job_plot_cmap_get_current(inst_id,ix_trial,tt)
% Get current time course for all of the vertices
%
% --- Syntax
% function J0 = job_plot_cmap_get_current(inst_id,ix_trial,tt)
%
% --- History
% ????-??-?? Taku Yoshioka
% 2008-08-28 Taku Yoshioka
% 2010-12-10 taku-y
%  [minor] Modified to match with the new variable definitions. 
% 2012-01-26 sako
%  [minor change] n_trial -> "n_trial" was replaced to "ix_trial"
%
% Copyright (C) 2011, ATR All Rights Reserved.
% License : New BSD License(see VBMEG_LICENSE.txt)

global vbmeg_inst; 
if isempty(vbmeg_inst.plotcmap{inst_id}.V), J0 = []; return; end
const = vb_define_verbose;
VERBOSE_LEVEL_DEBUG = const.VERBOSE_LEVEL_DEBUG;

%
% Global variables
%
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
%ix_trial = vbmeg_inst.plotcmap{inst_id}.ix_trial;
toi   = vbmeg_inst.plotcmap{inst_id}.toi;
Jinfo = vbmeg_inst.plotcmap{inst_id}.Jinfo;
%ix_bck  = vbmeg_inst.plotcmap{inst_id}.ix_bck;
%rb1 = vbmeg_inst.plotcmap{inst_id}.rb1;
%rb2 = vbmeg_inst.plotcmap{inst_id}.rb2;

if isempty(Jinfo), return; end

if isempty(tt), 
  tt=1:size(vbmeg_inst.plotcmap{inst_id}.Jact(1,:),2);
end
  
%
% Current map
%
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
J0 = zeros(size(vbmeg_inst.plotcmap{inst_id}.V,1),length(tt));

% Focal current
%if get(rb1,'Value')==get(rb1,'Max'),

% Debug code
if vb_get_verbose==VERBOSE_LEVEL_DEBUG,
  disp('--- job_plot_cmap_get_current');
  fprintf('length(Jinfo.ix_act)=%d\n',length(Jinfo.ix_act));
  fprintf('size(J0)\n'); 
  size(J0)
  fprintf('size(Jact(:,tt))\n'); 
  size(vbmeg_inst.plotcmap{inst_id}.Jact(:,tt))
  disp('--- pause');
  pause;
end

ix_act_ex = Jinfo.ix_act_ex;

if size(vbmeg_inst.plotcmap{inst_id}.Jact, 3) > 1
  ix_trial = vbmeg_inst.plotcmap{inst_id}.ix_trial;
  J0(ix_act_ex,:) = J0(ix_act_ex,:) + ...
    vbmeg_inst.plotcmap{inst_id}.Jact(:,tt,ix_trial);
else
  J0(ix_act_ex,:) = J0(ix_act_ex,:) + ...
    vbmeg_inst.plotcmap{inst_id}.Jact(:,tt);
end

% Background current
%if get(rb2,'Value')==get(rb2,'Max'), 
%  J0(ix_bck,:) = J0(ix_bck,:) + ...
%      vbmeg_inst.plotcmap{inst_id}.Jbck(:,tt,ix_trial);
%end  
