function job_edit_area_remove_corpus(inst_id)
%
% Remove corpus
%
%
% Copyright (C) 2011, ATR All Rights Reserved.
% License : New BSD License(see VBMEG_LICENSE.txt)

global vbmeg_inst; 

% Stack
job_edit_area_stack(inst_id);

% Global variables
Iextract = vbmeg_inst.editarea{inst_id}.Iextract;
nextDD = vbmeg_inst.editarea{inst_id}.nextDD;
nextIX = vbmeg_inst.editarea{inst_id}.nextIX;
F0 = vbmeg_inst.editarea{inst_id}.F0;
V0 = vbmeg_inst.editarea{inst_id}.V0;
ed3 = vbmeg_inst.editarea{inst_id}.ed3;
h_fig = vbmeg_inst.editarea{inst_id}.h_fig;

% Remove parameters
Dmax  = 0.02;   % Max distance to find large triangle in corpus callosal
Rmax  = 0.035;  % Max radius to extend remove region
Rstep = 0.007;  % Radius for single erosion
                % erosion is repeated (Rmax/Rstep) times

% Remove corpus
set(h_fig,'Pointer','watch');
[Vindx, Iremove] = vb_remove_corpus(F0,V0,nextIX,nextDD,Rmax,Rstep,Dmax);
Iextract{1} = intersect(Vindx,Iextract{1});
vbmeg_inst.editarea{inst_id}.Iextract = Iextract;
set(h_fig,'Pointer','arrow');

% Update screen and vertex number
job_edit_area_update_spatialpattern(inst_id);
set(ed3,'String',num2str(length(Iextract{1})));
