function job_edit_act_registration(inst_id)
% Store activity map to cortical activity file (.act.mat)
%
% --- Syntax
% job_edit_act_registration(inst_id)
%
% --- History
% ????-??-?? Taku Yoshioka
% 2008-09-04 Taku Yoshioka
%
% Copyright (C) 2011, ATR All Rights Reserved.
% License : New BSD License(see VBMEG_LICENSE.txt)

global vbmeg_inst;
if isempty(vbmeg_inst.editact{inst_id}.actfile), return; end

%
% Global variables
%
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
xxP = vbmeg_inst.editact{inst_id}.xxP;
lb1 = vbmeg_inst.editact{inst_id}.lb1;
actfile = vbmeg_inst.editact{inst_id}.actfile;

%
% Registration
%
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
str = inputdlg('Enter key of the activity map', ...
	       'Activity map registration',1,{'new_act'});
if length(str)>=1 & ~isempty(str{1}), 
  act.key = str{1};
  act.xxP = xxP{1};
  vb_add_act(actfile,act);
end

% Add new activity map to list box
set(lb1,'String',vb_get_keyset_act(actfile));
