function job_edit_act_print_spatialpattern(inst_id)
% Print screen
%
% --- Syntax
% job_edit_act_print_spatialpattern(inst_id)
%
% --- History
% 2009-05-22 Taku Yoshioka
%
% Copyright (C) 2011, ATR All Rights Reserved.
% License : New BSD License(see VBMEG_LICENSE.txt)

global vbmeg_inst; 
if isempty(vbmeg_inst.editact{inst_id}.V), return; end
if isempty(vbmeg_inst.editact{inst_id}.xxP), return; end

%
% Global variables
%
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
h_fig = vbmeg_inst.editact{inst_id}.h_fig; 
h_space = vbmeg_inst.editact{inst_id}.h_space;
h_cbar = vbmeg_inst.editact{inst_id}.h_cbar;
V = vbmeg_inst.editact{inst_id}.V;
F = vbmeg_inst.editact{inst_id}.F;
plot_parm = vbmeg_inst.editact{inst_id}.plot_parm;
ix = vbmeg_inst.editact{inst_id}.ix;
ed4 = vbmeg_inst.editact{inst_id}.ed4;
ed6 = vbmeg_inst.editact{inst_id}.ed6;
cb1 = vbmeg_inst.editact{inst_id}.cb1;
cb2 = vbmeg_inst.editact{inst_id}.cb2;
Vtal = vbmeg_inst.editact{inst_id}.Vtal;
model_type_fold_rb = vbmeg_inst.editact{inst_id}.model_type_fold_rb;
model_type_inflate_rb = ...
    vbmeg_inst.editact{inst_id}.model_type_inflate_rb;
xxP = vbmeg_inst.editact{inst_id}.xxP;
if ~isempty(xxP), xxP = xxP{1}; end

%
% Preparation for cortical surface plot
%
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
% Original/Inflated model
if get(model_type_fold_rb,'Value')==1,  
  V = vbmeg_inst.editact{inst_id}.V;
  inf_C = [];
else
  V = vbmeg_inst.editact{inst_id}.Vinf;
  inf_C = vbmeg_inst.editact{inst_id}.inf_C;
end

% Get display parameters
LRflag = [];
if get(cb1,'Value')==get(cb1,'Max'), LRflag = 'L'; end
if get(cb2,'Value')==get(cb2,'Max'), LRflag = [LRflag 'R']; end;
plot_parm.LRflag = LRflag;

if isempty(xxP), isact = 0; else isact = 1; end
plot_parm.isact = isact;
[az,el] = view;

%
% Plot brain activities superimposed on the cortical surface model
%
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
h_fig = figure;
job_edit_act_plotbrain(plot_parm,V,F,inf_C,xxP,min(xxP),max(xxP));
axis off;
axis tight;
axis equal;
set(h_space,'Box','on','XTick',[],'YTick',[],'ZTick',[]);
v = str2num(get(ed6,'String'));
if size(v)~=2, return; end;
if v(1)>=v(2), return; end;
caxis(gca,v);
%colorbar;
view([az,el]);

%
% Print figure
%
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
vb_epsfig(gcf,plot_parm.print_ratio,plot_parm.print_size);

[fig_dir,fig_file] = vb_file_select({'.eps'},'Save figure',true);

if ~isempty(fig_file), 
  figfile = [fig_dir filesep fig_file{1}];
  print(h_fig,'-depsc',figfile);
end

delete(h_fig);
