function job_edit_act_plotbrain(plot_parm,V,F,inf_C,J,Jmin,Jmax)
%
% Plot brain model
%
%
% Copyright (C) 2011, ATR All Rights Reserved.
% License : New BSD License(see VBMEG_LICENSE.txt)

vb_plot_cortex(plot_parm, V, F, inf_C);

% Left/Right hemisphere
switch plot_parm.LRflag
 case 'L'
  F0 = F.F3L;
 case 'R'
  F0 = F.F3R;
 case 'LR'
  F0 = F.F3;
end

% Select visible patches
index = plot_parm.index;
% Display activity
if plot_parm.isact
  plot_value(plot_parm,V,F0,J,index,Jmin,Jmax);
end

function plot_value(plot_parm,V,F0,J,index,wmin,wmax);
%
% x̕\
%

if length(J) == 0
  return;
end

% ʂI
if length(index) == 0
  tmp = ones(length(J),1);
else  
  tmp = zeros(length(J),1);
  tmp(index) = 1;
end

% ]^E]
tmp2 = zeros(length(J),1);
tmp2(unique(F0(:))) = 1;

tmp = J.*tmp.*tmp2;
ix = find(abs(tmp) >= wmin);
if plot_parm.wmode==1
  J = abs(J);
end

% x]fɏd˂ĕ\
if plot_parm.paint==1
  h = scatter3(V(ix,1),V(ix,2),V(ix,3),1,J(ix),'.','filled');
  set(h,'MarkerSize',plot_parm.ms);
else  
  FF = vb_patch_select2(ix,F0,size(V,1));  
  patch('Faces',FF,'Vertices',V,'FaceColor','interp',...
	'FaceVertexCData',J,'EdgeColor','none',...
	'FaceLighting','none');
  material dull;
end

if plot_parm.wmode==1
  caxis([0 wmax]);
else
  caxis([-wmax wmax]);
end
  
if plot_parm.cmap==1
  colormap(hot);
else
  colormap(jet);
end

