function job_edit_act_gauss_filter(inst_id)
% Apply Gaussian filter to activity map
%
% --- Syntax
% job_edit_act_gauss_filter(inst_id)
%
% --- History
% ????-??-?? Taku Yoshioka
% 2008-09-04 Taku Yoshioka
% 2009-05-01 Taku Yoshioka
%  Debug for stacking operation
%
% Copyright (C) 2011, ATR All Rights Reserved.
% License : New BSD License(see VBMEG_LICENSE.txt)

global vbmeg_inst; 
if isempty(vbmeg_inst.editact{inst_id}.xxP), return; end

%
% Global variables
%
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
ed2 = vbmeg_inst.editact{inst_id}.ed2;
nextDD = vbmeg_inst.editact{inst_id}.nextDD;
nextIX = vbmeg_inst.editact{inst_id}.nextIX;
h_fig = vbmeg_inst.editact{inst_id}.h_fig;

%
% Apply Gaussian filter
%
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
set(h_fig,'Pointer','watch');
drawnow;

% Stack
job_edit_act_stack(inst_id);
xxP = vbmeg_inst.editact{inst_id}.xxP;

% Radius (FWHM, mm)
R = str2num(get(ed2,'String'));
R = R/(2*sqrt(log(2)))*1e-3;
if R<=0, return; end;

% Smoothing and registration
I = length(nextDD);
W = job_edit_act_spatial_gauss_filter(nextDD,nextIX,R,2*R,1:I);
xxP{1} = W*xxP{1};
vbmeg_inst.editact{inst_id}.xxP = xxP;

%
% Update plot
%
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
job_edit_act_update_spatialpattern(inst_id);

set(h_fig,'Pointer','arrow');
