function job_edit_act_average(inst_id)
% Calculate average of activity values
%
% --- Syntax
% job_edit_act_average(inst_id)
%
% --- History
% ????-??-?? Taku Yoshioka
% 2008-09-04 Taku Yoshioka
% 2009-05-01 Taku Yoshioka
%  Debug for stacking operation
%
% Copyright (C) 2011, ATR All Rights Reserved.
% License : New BSD License(see VBMEG_LICENSE.txt)

global vbmeg_inst; 
if isempty(vbmeg_inst.editact{inst_id}.V), return; end
if isempty(vbmeg_inst.editact{inst_id}.xxP), return; end

%
% Global variables
%
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
lb1 = vbmeg_inst.editact{inst_id}.lb1; 
actfile = vbmeg_inst.editact{inst_id}.actfile; 

%
% Calculate average
%
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%

% Stack
job_edit_act_stack(inst_id);
xxP = vbmeg_inst.editact{inst_id}.xxP;

% Get activity map
i = get(lb1,'Value');
keyset = get(lb1,'String');
act = vb_get_act(actfile,keyset{i});

% Average activity information
xxP{1} = (xxP{2}+act.xxP)/2;
vbmeg_inst.editact{inst_id}.xxP = xxP;

%
% Update plot
%
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
job_edit_act_update_spatialpattern(inst_id);
