function varargout = vb_select_xyrange(key, varargin)
% vb_select_xyrange( key, varargin )
%
%  2դxyϰϤޥɥåǻꤹ뤿
%  Хå롼Ǥ
%
% key :  'init'  'delete'  'get'  'clear'  'SetBoxColor'
%        'SetReturnVariable'  'SetButtonUpFcn'  'SetInitialRange'
%
%   vb_select_xyrange( 'init', <axes handle>
%       [ , 'BoxColor', <color> ]
%       [ , 'ReturnVariable', <variable name> ]
%       [ , 'ButtonUpFcn', <function string> ]
%       [ , 'InitialRange', <range> ] )
%     <axes handle> ǻꤵ륰դоݤꤷޤ
%     Ȥơ'BoxColor', 'BoxStyle',
%     'ReturnVariable', 'ButtonUpFcn', 'InitialRange' Ǥ
%     줾Υץξܺ٤ϲ򻲾ȤƤ
%
%   vb_select_xyrange( 'delete', <axes handle> )
%     <axes handle> ǻꤵ륰դоݤޤ
%
%   vb_select_xyrange( 'get', <axes handle> )
%     <axes handle> ǻꤵ륰դˤ븽ߤϰϤ
%     ޤϷ [ x, y, x峦, y峦 ] Ǥ
%
%   vb_select_xyrange( 'clear', <axes handle> )
%     <axes handle> ǻꤵ륰դϰϤõޤ
%   
%   vb_select_xyrange( 'SetBoxColor', <axes handle>, <color> );
%     <axes handle> ǻꤵ륰դˤϰϤ򼨤BOXο
%     ꤷޤ<color>MatlabColorSpec˽򤷤ޤǥե
%     ͤ [ 1.0, 0.6, 0.6 ] Ǥ
%
%   vb_select_xyrange( 'SetReturnVariable', <axes_handle>, <variable name> );
%     <axes handle> ǻꤵ륰դˤϰϤϤ뤿
%     ΥХѿ̾ꤷޤ<variable name> ѿ̾
%     ʸˤʤޤǥեȤ϶Ǥ
%
%   vb_select_xyrange( 'SetButtonUpFcn', <axes_handle>, <command> );
%     <axes handle> ǻꤵ륰դˤɥåλ˼¹
%     륳ޥɤꤷޤǡ򤷤ϰϤѤˤϡ
%     xyrange Ȥѿ̾ѤƲ㤨С
%       >> vb_select_xyrange( 'SetButtonUpFcn', 'func( xyrange, var )' );
%     ʤɤˤꡢϰϤؿfuncΰȤϤޤǥե
%     Ȥ϶Ǥ
%
%   vb_select_xyrange( 'SetInitialRange', <range> );
%     <axes handle> ǻꤵ륰դˤϰϤνͤ
%     ꤷޤѤ뤳ȤˤꡢޥɥåʳǤϰ
%     ꤬ǽǤ<range>4ǤΥ٥ȥǡ 
%     [ x, y, x峦, y峦 ] Ǥ
%     ޥɥåǤϡɽդ礭ϰϻϤǤޤ󤬡
%     ǤϲǽǤǥեȤ϶Ǥ
%
%
% [ ñʻȤ ]
%
%   ޤоݤȤʤ륰դ axes handle ꤷޤ
%
%   >> vb_select_xyrange( 'set', <axes handle> );
%
%   ˤꡢоݥդޥǥɥå
%   򤵤줿xϰϤͳѷǰϤޤޤ
%   ϰϤ˥ˤϡ
%
%   >> vb_select_xyrange( 'get', <axes handle> );
%
%   ȤƤ
%
%
% Copyright (C) 2011, ATR All Rights Reserved.
% License : New BSD License(see VBMEG_LICENSE.txt)



const = vb_define_verbose;
VERBOSE_LEVEL_DEBUG = const.VERBOSE_LEVEL_DEBUG;

switch key

 % -----------------------------------------------------------------
 %  key : init
 % -----------------------------------------------------------------
 case 'init'  % axes  vb_select_xyrange оݤȤ

  % object handle 
  h = varargin{1};
  if ~ishandle(h), % | ~strcmp( get(h,'Type'), 'axes' )
    disp( 'error in vb_select_xyrange: invalid object handle' );
    return;
  end
  
  % Set hh to axes handle of parent of the object specified by
  % given handle
  hh = h;
  while true
    if strcmp(get(hh,'Type'),'axes'), break; end
    hh = get(hh,'Parent');
  end

  % åԴ  %%% 
  if mod( size(varargin,2), 2 ) ~= 1
    disp( 'invalid arguments for vb_select_xyrange( ''set'', ... )' );
    return;
  end 
  i = 2;
  while i < size(varargin,2)
    switch varargin{i}
     case 'BoxColor'
      boxcolor = varargin{i+1};
     case 'ReturnVariable'
      retvar = varargin{i+1};
     case 'ButtonUpFcn'
      upfcn = varargin{i+1};
     case 'InitialRange'
      xyrange = varargin{i+1};
     otherwise
      disp( 'invalid arguments for vb_select_xyrange( ''set'', ... )' );
      return;
    end
    i = i + 2;
  end
  % ---- åλ
  
  % ץΥǥե
  if ~exist('boxcolor'); boxcolor = [0.6,0.6,0.6]; end
  if ~exist('retvar'); retvar = []; end
  if ~exist('upfcn'); upfcn = []; end
  if ~exist('xyrange'); xyrange = []; end
  
  % object  ޥܥ򲡤ȤΥХå
  set( h, 'ButtonDownFcn',...
	  [ 'vb_select_xyrange(''down'',''' retvar ''',''' upfcn ''');' ] );
  
  % ¸ϰBOXк
  boxhandle = findobj( hh, 'Tag', 'SelX_BOX' );
  if ~isempty( boxhandle );
    delete( boxhandle );
  end
  
  boxhandle = findobj( hh, 'Tag', 'SelXY_BOX' );
  if ~isempty( boxhandle );
    delete( boxhandle );
  end
  
  % ϰBOX
  if isempty(xyrange)
    xlim = get( hh, 'XLim' );
    ylim = get( hh, 'YLim' );
    xinf = xlim(1);
    xsup = xlim(2);
    yinf = ylim(1);
    ysup = ylim(2);
  else
    xinf = xyrange(1);
    xsup = xyrange(3);
    yinf = xyrange(2);
    ysup = xyrange(4);
  end
  
  set(gcf, 'CurrentAxes', hh);
  boxhandle = ...
      patch( [ xinf, xsup, xsup, xinf ],...
	     [ yinf, yinf, ysup, ysup ], ...
	     boxcolor, 'HitTest', 'off', 'Visible', 'off',...
	     'Tag', 'SelXY_BOX' , ...
             'FaceColor', 'none', 'LineWidth', 2.5);
  if ~isempty(xyrange)
    set( boxhandle, 'Visible', 'on' );
  end
  % ----- 



 % -----------------------------------------------------------------
 %  key : delete
 % -----------------------------------------------------------------
 case 'delete'  % object  vb_select_xyrange оݤ
  
  % object handle 
  h = varargin{1};
  if ~ishandle(h), % | ~strcmp( get(h,'Type'), 'axes' )
    disp( 'error in vb_select_xyrange: invalid object handle' );
    return;
  end
  
  % Set hh to axes handle of parent of the object specified by
  % given handle
  hh = h;
  while true
    if strcmp(get(hh,'Type'),'axes'), break; end
    hh = get(hh,'Parent');
  end

  % ϰBOXк (BOX'init'ɬ)
  boxhandle = findobj( hh, 'Tag', 'SelX_BOX' );
  if ~isempty( boxhandle );
    delete( boxhandle );
    set( h, 'ButtonDownFcn', [] );
  end
  
  boxhandle = findobj( hh, 'Tag', 'SelXY_BOX' );
  if ~isempty( boxhandle );
    delete( boxhandle );
    set( h, 'ButtonDownFcn', [] );
  end



 % -----------------------------------------------------------------
 %  key : down
 % -----------------------------------------------------------------
 case 'down' % ޥܥ󤬲줿Ȥ (Box,
             % WindowButtonMotionFcn, WindowButtonUpFcn )

  %  : retvar --- ѥХѿ,  
  %        upfcn --- ޥܥΥȤΥޥ
  retvar = varargin{1};
  upfcn = varargin{2};
  
  % Debug code
  if vb_get_verbose==VERBOSE_LEVEL_DEBUG, 
    disp('vb_select_xyrange(''down'') invoked');
    fprintf('upfcn=%s\n',upfcn);
  end

  % ͭʤΤϺåΤ
  if strcmp( get( gcf, 'SelectionType' ), 'normal' ) == 0
    return;
  end
  
  % BOXκ
  acpt = get( gca, 'CurrentPoint' );  
  xlim = get( gca, 'XLim' );
  ylim = get( gca, 'YLim' );
  xini = max( xlim(1), acpt(1) ); % ϰ
  xini = min( xlim(2), xini );    % դaxisΤ
  yini = max( ylim(1), acpt(3) ); % ϰ
  yini = min( ylim(2), yini );    % դaxisΤ
  boxhandle = findobj( gca, 'Tag', 'SelXY_BOX' ); % BOXΥϥɥ
  set( boxhandle, 'XData', [ xini, xini, xini, xini ],...
		  'YData', [ yini, yini, yini, yini ],...
                  'Visible', 'on' );
  
  % ޥưȤȥܥΥȤΥХå
  set( gcf, 'WindowButtonMotionFcn', 'vb_select_xyrange(''move'')' );
  if isempty( retvar )
    set( gcf, 'WindowButtonUpFcn',...
	      [ 'vb_select_xyrange(''up'',''' upfcn ''');' ] );
  else
    set( gcf, 'WindowButtonUpFcn',...
	      [ retvar ' = vb_select_xyrange(''up'',''' upfcn ''');' ] );
  end
  
 

 % -----------------------------------------------------------------
 %  key : move
 % -----------------------------------------------------------------
 case 'move' % ޥưȤ

  % BOXκ
  acpt = get( gca, 'CurrentPoint' );
  xlim = get( gca, 'XLim' );
  ylim = get( gca, 'YLim' );
  xcur = max( xlim(1), acpt(1) ); % ϰ
  xcur = min( xlim(2), xcur );    % դaxisΤ
  ycur = max( ylim(1), acpt(3) ); % ϰ
  ycur = min( ylim(2), ycur );    % դaxisΤ
  boxhandle = findobj( gca, 'Tag', 'SelXY_BOX' ); % BOXΥϥɥ
  temp = get( boxhandle, 'XData' );
  xini = temp(1);
  set( boxhandle, 'XData', [ xini, xcur, xcur, xini ] );
  temp = get( boxhandle, 'YData' );
  yini = temp(1);
  set( boxhandle, 'YData', [ yini, yini, ycur, ycur ] );
  
  % Debug code
  if vb_get_verbose==VERBOSE_LEVEL_DEBUG, 
    disp('vb_select_xyrange(''move'') invoked');
    fprintf('xyrange=[%f %f %f %f]\n',xini,xcur,yini,ycur);
  end

 % -----------------------------------------------------------------
 %  key : up
 % -----------------------------------------------------------------
 case 'up' % ޥܥΥȤ

  %  : upfcn --- ޥܥΥȤΥޥ
  upfcn = varargin{1};
  
  % ޥưȤȥޥܥΥȤΥХåβ
  set( gcf, 'WindowButtonMotionFcn', [] );
  set( gcf, 'WindowButtonUpFcn', [] );
  
  % BOXκ
  acpt = get( gca, 'CurrentPoint' );
  xlim = get( gca, 'XLim' );
  ylim = get( gca, 'YLim' );
  xcur = max( xlim(1), acpt(1) );
  xcur = min( xlim(2), xcur );
  ycur = max( ylim(1), acpt(3) );
  ycur = min( ylim(2), ycur );
  boxhandle = findobj( gca, 'Tag', 'SelXY_BOX' );
  temp = get( boxhandle, 'XData' );
  xini = temp(1);
  set( boxhandle, 'XData', [ xini, xcur, xcur, xini ] );
  temp = get( boxhandle, 'YData' );
  yini = temp(1);
  set( boxhandle, 'YData', [ yini, yini, ycur, ycur ] );
  
  % ϰ
  xrange = sort( [ xini, xcur ] );
  yrange = sort( [ yini, ycur ] );
  xyrange = [xrange(1) yrange(1) xrange(2) yrange(2)];
  
  % 桼ؿƤӽФ
  if ~isempty( upfcn )
    eval( upfcn );
  end
  
  % ͤȤƽ
  varargout{1} = xyrange;
  

 
 % -----------------------------------------------------------------
 %  key : get
 % -----------------------------------------------------------------
 case 'get' % ϰϤμ
  
  % object handle 
  h = varargin{1};
  if ~ishandle(h), % | ~strcmp( get(h,'Type'), 'axes' )
    disp( 'error in vb_select_xyrange: invalid object handle' );
    varargout{1} = [];
    return;
  end
  
  % Set hh to axes handle of parent of the object specified by
  % given handle
  hh = h;
  while true
    if strcmp(get(hh,'Type'),'axes'), break; end
    hh = get(hh,'Parent');
  end
  
  % BOXΥϥɥ  н
  boxhandle = findobj( hh, 'Tag', 'SelXY_BOX' );
  if ~isempty(boxhandle) &...
     strcmp( get( boxhandle, 'Visible' ), 'on' ) == 1;
    xdat = get( boxhandle, 'XData' );
    ydat = get( boxhandle, 'YData' );
    xrange = sort( [ xdat(1), xdat(2) ] );
    yrange = sort( [ ydat(1), ydat(3) ] );
    xyrange = [xrange(1) yrange(1) xrange(2) yrange(2)];
    varargout{1} = xyrange;
  else
    varargout{1} = [];
  end
  


 % -----------------------------------------------------------------
 %  key : clear
 % -----------------------------------------------------------------
 case 'clear'  % BOXξõ
  
  % object handle 
  h = varargin{1};
  if ~ishandle(h), % | ~strcmp( get(h,'Type'), 'axes' )
    disp( 'error in vb_select_xyrange: invalid object handle' );
    return;
  end
  
  % Set hh to axes handle of parent of the object specified by
  % given handle
  hh = h;
  while true
    if strcmp(get(hh,'Type'),'axes'), break; end
    hh = get(hh,'Parent');
  end

  % BOXΥϥɥ  Ļ벽
  boxhandle = findobj( hh, 'Tag', 'SelXY_BOX' );
  if ~isempty(boxhandle)
    xlim = get( hh, 'XLim' );
    set( boxhandle, 'Visible', 'off' );
  end



 % -----------------------------------------------------------------
 %  key : SetBoxColor
 % -----------------------------------------------------------------
 case 'SetBoxColor'  % ϰBOXο (Դ) %%%
  
  % object handle 
  h = varargin{1};
  if ~ishandle(h), % | ~strcmp( get(h,'Type'), 'axes' )
    disp( 'error in vb_select_xyrange: invalid object handle' );
    return;
  end
  
  % Set hh to axes handle of parent of the object specified by
  % given handle
  hh = h;
  while true
    if strcmp(get(hh,'Type'),'axes'), break; end
    hh = get(hh,'Parent');
  end
  
  %  : ꤹ뿧 (åɬ)
  boxcolor = varargin{2};

  % BOXΥϥɥ  пѹԴ %%%
  boxhandle = findobj( hh, 'Tag', 'SelXY_BOX' );
  if ~isempty(boxhandle)
    set( boxhandle, 'FaceVertexCData', boxcolor );
  end
  


 % -----------------------------------------------------------------
 %  key : SetReturnVariable
 % -----------------------------------------------------------------
 case 'SetReturnVariable' % ܥΥȤϰϤϤ
                          % ΥХѿ

  % object handle 
  h = varargin{1};
  if ~ishandle(h), % | ~strcmp( get(h,'Type'), 'axes' )
    disp( 'error in vb_select_xyrange: invalid object handle' );
    return;
  end
  
  %  : ꤹѿ (åɬסԲǽ) %%%
  retvar = varargin{2};

  % axes ButtonDownFcn Хåνľ
  bdf = get( h, 'ButtonDownFcn' );
  i = findstr( bdf, 'vb_select_xyrange' );
  if ~isempty( i )
    c = findstr( bdf, ',' );
    set( h, 'ButtonDownFcn',...
	    [ bdf(1:c(1)+1), retvar, bdf(c(2)-1:size(bdf,2)) ] );
  end
  
  

 % -----------------------------------------------------------------
 %  key : SetButtonUpFcn
 % -----------------------------------------------------------------
 case 'SetButtonUpFcn'  % ܥΥȤ˼¹Ԥ륳ޥɤ

  % object handle 
  h = varargin{1};
  if ~ishandle(h), % | ~strcmp( get(h,'Type'), 'axes' )
    disp( 'error in vb_select_xyrange: invalid object handle' );
    return;
  end

  %  : ꤹ륳ޥ (åɬסԲǽ) %%%
  upfcn = varargin{2};
  
  % axes ButtonDownFcn Хåνľ
  bdf = get( h, 'ButtonDownFcn' );
  i = findstr( bdf, 'vb_select_xyrange' );
  if ~isempty( i )
    c = findstr( bdf, ',' );
    set( h, 'ButtonDownFcn',...
	    [ bdf(1:c(2)+1), upfcn, ''');' ] );
  end


 % -----------------------------------------------------------------
 %  key : SetInitialRange
 % -----------------------------------------------------------------
 case 'SetInitialRange'  % ޥɥåϰϤ
  
  % object handle 
  h = varargin{1};
  if ~ishandle(h), % | ~strcmp( get(h,'Type'), 'axes' )
    disp( 'error in vb_select_xyrange: invalid object handle' );
    return;
  end
  
  % Set hh to axes handle of parent of the object specified by
  % given handle
  hh = h;
  while true
    if strcmp(get(hh,'Type'),'axes'), break; end
    hh = get(hh,'Parent');
  end
  
  %  : ꤹϰ (åɬ) %%%
  xyrange = varargin{2};
  
  % BOXΥϥɥ  кĻ벽
  boxhandle = findobj( hh, 'Tag', 'SelXY_BOX' );
  if ~isempty(boxhandle)
    set( boxhandle, 'XData', [xrange(1),xrange(3),xrange(3),xrange(1)],...
                    'YData', [xrange(2),xrange(2),xrange(4),xrange(4)],...
		    'Visible', 'on');
  end


  
 % -----------------------------------------------------------------
 %  key : ¾ ʥ顼
 % -----------------------------------------------------------------
 otherwise
  disp( 'Invalid key for vb_select_xyrange()' );


  
end % switch key

