function [def, cancel] = vb_input_settings(def, dlg_name, save_func)
% Launch setting input dialog
% [USAGE]
%    [def, cancel] = vb_input_settings(def, dlg_name [,mfile_saver_func]);
% [IN]
%          def : definition for input items.
%     dlg_name : dialog title [string]
%    save_func : (opt)If you want to save the parameter as a m-file,
%                     give a function handle to the argument.
%                     feval(mfile_save_func, def) will be called when pushing
%                     the save button.
%                     saver function should process the request properly.
% [OUT]
%      def : definition for input items.
%   cancel : =  true : closed with x button or cancel button, 
%            = false : closed with ok button.
% [example]
%   items = {
%    {'type', 'directory selection', 'value', pwd, 'title', 'FS SUBJECT directory', 'help', 'The help of FS_SUBJECT directory'},...
%    {'type', 'single file selection', 'extension', '.img', 'title', 'Image file', 'help', 'The help of Image file'}, ...
%    {'type', 'string input', 'title', 'Subject ID', 'help', 'The help of Subject ID'},
%   };
%   [items, cancel] = vb_input_settings(items, 'FreeSurfer', @save_func);
%
% [See]
%   vb_input_settings.txt
%
% Copyright (C) 2011, ATR All Rights Reserved.
% License : New BSD License(see VBMEG_LICENSE.txt)

if ~exist('dlg_name', 'var')
    dlg_name = '';
end
if ~exist('save_func', 'var')
    save_func = [];
end

% Open figure
pg_path = vb_get_file_parts(which(mfilename));
fig = openfig(fullfile(pg_path, filesep, 'vb_input_settings.fig'));
H = guihandles(fig);
set(fig, 'Name', dlg_name);
%warning('setColorProperty');
%setColorProperty;

% data difinition
data = struct;
data.H    = H;
data.def = def;
data.org_def = def;
data.save_func = save_func;

data.cancel = false; % close with x button
try
% Set listbox
Nitem = size(def, 2);
for k=1:Nitem
    item = def{k};
    name = vb_input_settings_get_prop(item, 'title');
    name_list{k} = [num2str(k), '.' name];
end
set(H.name_listbox, 'String', name_list);
catch
    error('Error occured!');
end

% Set visibility of "Save as" button
if isa(data.save_func, 'function_handle')
    set(H.saveas_push, 'Visible', 'on');
end

% Save definition
guidata(fig, data);
% update screen
vb_input_settings_update_gui(data);

waitfor(fig, 'Visible', 'off');

% load updated data during waitfor(fig)
if ishandle(fig)
    data = guidata(fig);
    def = data.def;
    delete(fig);
end

cancel = data.cancel;
