function project_mgr_contextmenu_callback(fig, hObj)
% callback function for history context menu.
% [USAGE]
%    project_mgr_contextmenu_callback(<fig>, <hObj>);
% [IN]
%     fig : figure handle of project_mgr gui.
%    hObj : event component handle.
% [OUT]
%    none
%
% Copyright (C) 2011, ATR All Rights Reserved.
% License : New BSD License(see VBMEG_LICENSE.txt)

%
% --- Previous check
%
if ~exist('fig', 'var') || isempty(fig) || ~ishandle(fig)
    error('invalid figure handle is specified.');
end

%
% --- Main Procedure
%
drawnow;

% load data (@see project_mgr)
data = guidata(fig);
H = data.H; % component handles

% % protect application screen
% set(fig, 'HandleVisibility', 'off');

% project_root
proj_root = get(H.project_root_edit, 'String');


% - get selected parameter and type
selected_line_no = get(H.history_listbox, 'Value');
max_line_no      = length(get(H.history_listbox, 'String'));
[parm, parm_type] = project_file_mgr('get_parameter', selected_line_no);
func_type = vb_judge_function_name(parm, parm_type);
switch(hObj)
    case H.submenu_launch_application
        % launch application
        switch(func_type)
            case 'vb_job_brain'
                project_mgr_launch_module(fig, 'brain', parm);
            case 'vb_job_fmri'
                project_mgr_launch_module(fig, 'fmri', parm);
            case 'vb_job_meg'
                [Measurement, Device] = vb_meg_parm_get_measurement(parm);
                if strcmp(Measurement, 'MEG') && strcmp(Device, 'YOKOGAWA')
                    project_mgr_launch_module(fig, 'yokogawa_meg', parm);
                elseif strcmp(Measurement, 'EEG') && strcmp(Device, 'BIOSEMI')
                    project_mgr_launch_module(fig, 'biosemi_eeg', parm);
                elseif strcmp(Measurement, 'EEG') && strcmp(Device, 'BRAINAMP');
                    project_mgr_launch_module(fig, 'brainamp_eeg', parm);
                else
                    project_mgr_launch_module(fig, 'sbi_meg', parm);
                end
            case 'vb_job_leadfield'
                project_mgr_launch_module(fig, 'leadfield', parm);
            case 'vb_job_vb'
                project_mgr_launch_module(fig, 'bayes', parm);
            case 'vb_job_current'
                project_mgr_launch_module(fig, 'current', parm);
            case 'vb_job_head_3shell'
                project_mgr_launch_module(fig, 'spm_curry_head', parm);
        end
    case H.submenu_export_script
        project_mgr_export_as_script(proj_root, parm, parm_type);
    case H.submenu_job_view_cortex
        % caution : I expect parameter field name is same.
        brain_file = fullfile(proj_root, parm.brain_file);
        area_file  = fullfile(proj_root, parm.area_file);
        act_file   = fullfile(proj_root, parm.act_file);

        vb_act_area_viewer(brain_file, act_file, area_file);
    case H.submenu_view_head
        head_file = fullfile(proj_root, parm.head_file);
        mri_file  = parm.analyze_file;
        vb_view_head_2d(mri_file, head_file);
    case H.submenu_job_select_area
        % caution : I expect parameter field name is same.
        brain_file = fullfile(proj_root, parm.brain_file);
        area_file  = fullfile(proj_root, parm.area_file);
        act_file   = fullfile(proj_root, parm.act_file);

        brain_exist = exist(brain_file, 'file');
        act_exist = exist(area_file, 'file');
        area_exist = exist(act_file,  'file');

        if ~brain_exist
            errordlg('cannot launch job_select_area', 'Cortical model file not found.');
            return;
        end
        if ~act_exist
            errordlg('cannot launch job_select_area', 'Cortical activity file not found.');
            return;
        end
        if ~area_exist
            errordlg('cannot launch job_select_area', 'Cortical area file not found.');
            return;
        end
        job_select_area(brain_file, area_file, act_file);
        
    case H.submenu_job_edit_area
        % caution : I expect parameter field name is same.
        brain_file = fullfile(proj_root, parm.brain_file);
        area_file  = fullfile(proj_root, parm.area_file);
        act_file   = fullfile(proj_root, parm.act_file);

        brain_exist = exist(brain_file, 'file');
        act_exist = exist(act_file, 'file');
        area_exist = exist(area_file,  'file');

        if ~brain_exist
            errordlg('cannot launch job_edit_area', 'Cortical model file not found.');
            return;
        end
        if ~act_exist
            errordlg('cannot launch job_edit_area', 'Cortical activity file not found.');
            return;
        end
        if ~area_exist
            errordlg('cannot launch job_edit_area', 'Cortical area file not found.');
            return;
        end
        job_edit_area(brain_file, area_file);
    case H.submenu_job_edit_act
        % caution : I expect parameter field name is same.
        brain_file = fullfile(proj_root, parm.brain_file);
        act_file   = fullfile(proj_root, parm.act_file);
        
        brain_exist = exist(brain_file, 'file');
        act_exist = exist(act_file, 'file');
        
        if ~brain_exist
            errordlg('cannot launch job_edit_act', 'Cortical model file not found.');
            return;
        end
        if ~act_exist
            errordlg('cannot launch job_edit_act', 'Cortical activity file not found.');
            return;
        end
        job_edit_act(brain_file, act_file);
    case H.submenu_job_plot_meg
        proj_root = get(H.project_root_edit, 'String');
        [Measurement, Device] = vb_meg_parm_get_measurement(parm);
        if strcmp(Measurement, 'MEG')
            meg_file = [proj_root, '/', parm.meg_file];
        elseif strcmp(Measurement, 'EEG') && ...
                (strcmp(Device, 'BIOSEMI') || strcmp(Device, 'BRAINAMP'))
            meg_file = [proj_root, '/', parm.output_file];
        end
        job_plot_meg(meg_file);

    case H.submenu_job_plot_currentmap
        %current_parm.resultfile-->brain_file
        result_file  = fullfile(proj_root, parm.bayesfile);
        load(result_file, 'bayes_parm');

        brain_file   = fullfile(proj_root, bayes_parm.brainfile);
        current_file = fullfile(proj_root, parm.currfile);
        brain_exist   = exist(brain_file, 'file');
        current_exist = exist(current_file, 'file');

        if ~brain_exist
            errordlg('cannot launch job_plot_currentmap', 'Cortical model file not found.');
            return;
        end
        if ~current_exist
            errordlg('cannot launch job_plot_currentmap', 'Current file not found.');
            return;
        end
        job_plot_currentmap(brain_file, current_file);
end
drawnow;
% protect application screen end
set(H.figure, 'HandleVisibility', 'callback');
