function [data, name] = project_mgr_builder_remove(data)
% Remove batch builder
% [USAGE]
%    [data] = project_mgr_builder_remove(<data>);
% [IN]
%    data : project_mgr data
% [OUT]
%    data : project_mgr data(updated)
%    name : removed builder name
%
% Copyright (C) 2011, ATR All Rights Reserved.
% License : New BSD License(see VBMEG_LICENSE.txt)

%
% --- Previous check
%
if ~exist('data', 'var')
    error('data is a required parameter.');
end

%
% --- Main Procedure
%
H = data.H;

% get selected batch builder
idx = get(H.builder_popup, 'Value');
rbuilder = data.batch_builders{idx};
name     = vb_batch_mgr_get_name(rbuilder);
% remove builder
data.batch_builders(idx) = [];
if isempty(data.batch_builders)
    data.batch_builders{1} = vb_batch_mgr_new('batch builder1');
end

% Save builders to file
batch_builders = data.batch_builders;
result = vb_save(data.project_file, 'batch_builders');

%
% --- After check
%
if nargout < 1
    error('function caller should receive this object.');
end
