function [data] = project_mgr_builder_open(data)
% Open batch builder gui
% [USAGE]
%    [data] = project_mgr_open_builder_open(<data>);
% [IN]
%    data : project_mgr data
% [OUT]
%    data : project_mgr data(updated)
%
% Copyright (C) 2011, ATR All Rights Reserved.
% License : New BSD License(see VBMEG_LICENSE.txt)

%
% --- Previous check
%
if ~exist('data', 'var')
    error('data is a required parameter.');
end

%
% --- Main Procedure
%
H = data.H;

if ishandle(data.batch_fig)
    figure(data.batch_fig);
else
    proj_root = get(H.project_root_edit, 'String');
    proj_name = get(H.project_name_edit, 'String');
    proj_file = data.project_file;

    % get selected batch builder
    idx = get(H.builder_popup, 'Value');
    % launch batch buider gui.
    data.batch_fig = vb_batch_list_new(proj_root, proj_name, proj_file, ...
                                       data.batch_builders{idx});
end

% GUI state disable
set(H.builder_popup, 'Enable', 'off');
set(H.open_builder_push, 'Enable', 'off');

%
% --- After check
%
if nargout < 1
    error('function caller should receive data.');
end
