function [cancelled, err, project_filename] = create_new_project
% This function launch the gui for making new project.
% [USAGE]
%    [cancelled, err, project_filename] = create_new_project('init');
% [IN]
%    none
% [OUT]
%    cancelled : true(create project cancelled.) or false.
%    err       : true(error occured.) or false.
%    project_filename : created new project file(absolute path).
%
% Copyright (C) 2011, ATR All Rights Reserved.
% License : New BSD License(see VBMEG_LICENSE.txt)

fig      = openfig(mfilename);
H        = guihandles(fig);
H.figure = fig;

% init data
data = struct;
data.cancelled = false;
data.err = false;
data.project_filename = [];
data.H = H;

% save data to figure.
guidata(fig, data);

% SetFocus
if vb_matlab_version >= 7
    uicontrol(H.project_name_edit);
end

% wait for figure visible off
waitfor(fig, 'Visible', 'off'); %%% visible off ==> waitfor cancelled.

% load data to figure.
data = guidata(fig);

% set return value
cancelled        = data.cancelled;
err              = data.err;
project_filename = data.project_filename;

% delete figure
delete(fig);
