function pa_sbi_meg_set_parm(fig, sbi_meg_parm)
% This function sets parameters to sbi meg parameter gui.
% [USAGE]
%    pa_sbi_meg_set_parm(<fig> [,sbi_meg_parm]);
% [IN]
%             fig : figure handle of leafield gui.
%    sbi_meg_parm : to be set sbi_meg_parm [default:vb_set_sbi_meg_parm()]
% [OUT]
%    none
%
% Copyright (C) 2011, ATR All Rights Reserved.
% License : New BSD License(see VBMEG_LICENSE.txt)

%
% --- Previous check
%
if ~exist('fig', 'var') || isempty(fig) || ~ishandle(fig)
    error('invalid figure handle.');
end
% default value
if isempty(sbi_meg_parm)
    sbi_meg_parm = vb_set_sbi_meg_parm;
end


%
% --- Main Procedure
%

% load data(@see pa_sbi_meg_create)
data = guidata(fig);

H = data.H; % component handles

% SBI file
set(H.sbi_file_edit, 'String', sbi_meg_parm.sbi_file);

% DICOM file
dicom_str = [sbi_meg_parm.dicom_dir sbi_meg_parm.dicom_file];
set(H.Dicom_file_edit, 'String', dicom_str);

% Analyze file
set(H.analyze_edit, 'String', sbi_meg_parm.analyze_file);

% keyword
if isfield(sbi_meg_parm, 'keyword')
    set(H.keyword_edit, 'String', sbi_meg_parm.keyword);
end

% Comment
if isfield(sbi_meg_parm, 'comment')
    set(H.comment_edit, 'String', sbi_meg_parm.comment);
end


% Save dir
%[save_dir] = fileparts(meg_parm.meg_file);
[save_dir] = vb_get_file_parts(sbi_meg_parm.meg_file);
set(H.save_dir_edit, 'String', save_dir);

% MEG-MAT file(output)
set(H.megmat_file_edit, 'String', sbi_meg_parm.meg_file);

pa_sbi_meg_util(fig, 'update_exec_push_status');


% save data
data.sbi_meg_parm = sbi_meg_parm;
guidata(fig, data);
