function H = pa_sbi_meg_callback(fig, hObj)
% callback function for sbi meg gui.
% [USAGE]
%    pa_sbi_meg_callback(<fig>, <hObj>);
% [IN]
%     fig : figure handle of sbi meg gui.
%    hObj : event component handle.
% [OUT]
%    none
%
% Copyright (C) 2011, ATR All Rights Reserved.
% License : New BSD License(see VBMEG_LICENSE.txt)

%
% --- Previous check
%
if ~exist('fig', 'var') || isempty(fig) || ~ishandle(fig)
    error('invalid figure is specified.');
end
if ~exist('hObj', 'var')
    error('hObj is a required parameter.');
end

%
% --- Main Procedure
%
global vbmeg_inst;
define = vbmeg_inst.const;

% load data(@see pa_sbi_meg_create)
data = guidata(fig);
H = data.H;

switch(hObj)
    case H.prjroot_push
        dir = dir_dialog(get(H.prjroot_edit, 'String'));
        if dir ~= 0
            set(H.prjroot_edit, 'String', dir);
        end
    case H.analyze_push
        [dir fname] = vb_file_select({'.hdr'});
        if ~isempty(dir)
            set(H.analyze_edit, 'String', [dir filesep fname{1}]);
        end
    case H.sbi_push
        [dir fname] = vb_file_select({define.MEG1_EXTENSION});
        if ~isempty(dir)
            set(H.sbi_file_edit, 'String', [dir filesep fname{1}]);
        end
        pa_sbi_meg_util(fig, 'update_exec_push_status');
        pa_sbi_meg_util(fig, 'update_output_fname');
    case H.Dicom_push
        [dir fname] = vb_file_select({define.DICOM1_EXTENSION});
        if ~isempty(dir)
            set(H.Dicom_file_edit, 'String', [dir filesep fname{1}]);
        end
        pa_sbi_meg_util(fig, 'update_output_fname');
    case H.save_dir_push
        proj_root = get(H.prjroot_edit, 'String');
        [dir canceled] = pa_prjdir_select(proj_root);
        if ~canceled
            set(H.save_dir_edit, 'String', dir);
        end
        pa_sbi_meg_util(fig, 'update_output_fname');
    case H.meg_reset_push
        pa_sbi_meg_util(fig, 'reset_parameter');
        pa_sbi_meg_util(fig, 'update_exec_push_status');
    case H.meg_exec_push
        pa_sbi_meg_util(fig, 'exec_meg');
    case H.sbi_file_edit
        pa_sbi_meg_util(fig, 'update_exec_push_status');
    case H.Dicom_file_edit
        pa_sbi_meg_util(fig, 'update_exec_push_status');
    case H.keyword_edit
        pa_sbi_meg_util(fig, 'update_output_fname');
        pa_sbi_meg_util(fig, 'update_exec_push_status');
    case H.comment_edit
        pa_sbi_meg_util(fig, 'update_exec_push_status');
    case H.save_dir_edit
        pa_sbi_meg_util(fig, 'update_output_fname');
end

% save data
guidata(fig, data);
