function [obj] = vb_timeseries_viewer_set_trial(obj, trial_list)
% set trial data. if you also want to update screen, 
% call vb_timeseries_viewer_update_trial.
%
% [Usage]
%    [obj] = vb_timeseries_viewer_set_trial(obj, trial_list);
%
% [Input]
%           obj : vb_timeseries_viewer object.
%    trial_list : trial list <<struct list>>
%                 trial_list(N).from
%                              .to
%                              .onset
% [Output]
%    obj : updated vb_timeseries_viewer object.
% [See also]
%   vb_timeseries_viewer_update_trial.m
%
% Copyright (C) 2011, ATR All Rights Reserved.
% License : New BSD License(see VBMEG_LICENSE.txt)

%
% --- Previous check
%
if ~exist('obj', 'var')
    error('obj is a required parameter.');
end
if ~exist('trial_list', 'var')
    error('trial_list is a required parameter.');
end

%
% --- Main Procedure
%
for k=1:length(trial_list)
    % timeseriesviewer uses this field to memorize each trial is valid or not.
    trial_list(k).invalid = false;
end
obj.trial_list = trial_list;

%
% --- After check
%
if nargout ~= 1
    error('you should receive updated vb_timeseries_viewer object.');
end
