function [obj] = vb_timeseries_viewer_plot_trigger_data(obj, window_from, window_to)
% plot trigger data
% [USAGE]
%    [obj] = vb_timeseries_viewer_plot_trigger_data(obj, window_from, window_to);
% [IN]
%    obj : vb_timeseries_viewer object.
% [OUT]
%    obj : vb_timeseries_viewer object.
%
% Copyright (C) 2011, ATR All Rights Reserved.
% License : New BSD License(see VBMEG_LICENSE.txt)

%
% --- Previous check
%
if ~exist('obj', 'var')
    error('obj is a required parameter.');
end

%
% --- Main Procedure
%

H = obj.H;

cla(H.trigger_axes);

% Remove previous legend
if isfield(obj, 'ext_legend_handle')
    try
    delete(obj.ext_legend_handle);
    catch
    end
end
if ~isempty(obj.trig_ch_list_plot_ix)
    freq    = vb_continuous_file_get_sample_freq(obj.trigger_obj);
    [obj.trigger_obj, trig_data, from, to, read_ch_name] = vb_continuous_file_get_sample(obj.trigger_obj, ...
                                                       obj.trig_ch_list(obj.trig_ch_list_plot_ix), ...
                                                       ceil(freq*window_from), ceil(freq*window_to));
    if ~isempty(trig_data)
        % plot trigger
        step = 1;
        t  = [from-1:to-1]/freq;
        ix = [1:step:size(trig_data,2)];
        obj.handle_ext_lines = ...
                plot(H.trigger_axes, t(1:step:length(t)), trig_data(:, ix));

        % Plot legend
        l_h = legend(H.trigger_axes, read_ch_name);
        try
        set(l_h, 'FontSize', 10.5, 'FontUnit', 'points');
        catch
        set(l_h, 'FontSize', 10.5);
        end
%        set(l_h, 'FontUnit', 'normalized');

        % set position
        obj.ext_legend_handle = l_h;
    end



% trigger onset
%    Ntrial = length(obj.trial_list);
%    ymax = max(trig_data(:));
%    ymin = min(trig_data(:));
end

% set(obj.figure, 'CurrentAxes', H.trigger_axes);
% axes(H.trigger_axes);
% for k=1:Ntrial
%     t = obj.trial_list(k);
%     patch([t.onset, t.onset, t.onset, t.onset], ...
%                            [ymin, ymin, ymax, ymax], ...
%                            [0.2, 0.2, 0.2]);
% 
% end

% Set Label(should be done after plotting)
% h = xlabel(H.trigger_axes, 'Time[sec]', ...
%                         'FontName', 'Times', ...
%                         'FontUnit', 'points', 'FontSize', 14);
% set(h, 'FontUnit', 'normalized');
% 
% h = ylabel(H.trigger_axes, 'External trigger', ...
%                        'FontName', 'Times', ...
%                        'FontUnit', 'points', 'FontSize', 14);
% set(h, 'FontUnit', 'normalized');
% 
% % Set Axis font
% set(H.trigger_axes, 'FontName', 'Times', ...
%                     'FontUnit', 'points');
% set(H.trigger_axes, 'FontSize', 14);
% set(H.trigger_axes, 'FontUnit', 'normalized');


% Set Grid on
set(H.trigger_axes, 'XGrid', 'on');
set(H.trigger_axes, 'YGrid', 'on');


% Yrange
range = ylim(H.trigger_axes);
set(H.ylimit_trigger_low_edit, 'String', num2str(range(1)));
set(H.ylimit_trigger_high_edit, 'String', num2str(range(2)));

xlim(H.trigger_axes, [window_from, window_to]);
