function [trial_list, trig_ch_list] = vb_timeseries_viewer_load_trigger_file(trigger_obj, trigger_file)
% load trigger file and return the trial, trigger channel information
% [Input]
%     trigger_obj : vb_continuous_file object for trigger.
%    trigger_file : trigger file(.trig.mat)
%
trig = load(trigger_file);
Nsample = vb_continuous_file_get_Nsample(trigger_obj);

% consistency check between status channel and MEG/EEG sample
if length(trig.status_out) ~= Nsample
    res =  questdlg(['Specified trigger file and MEG/EEG file have ', ...
                     'different sample number. Continue operation?'], ...
                    'Confirm', 'Yes', 'No', 'No');
    if strcmpi(res, 'No')
        trial_list  = [];
        trig_ch_list = [];
        return;
    end
end

% Create trial information
trial_list = [];
if exist('trig', 'var')
    freq = vb_continuous_file_get_sample_freq(trigger_obj);
    for k=1:length(trig.trig)
        trial = struct;
        trial.from  = trig.trig(k)/freq - trig.parm.Pretrigger_ms/1000; % sec
        trial.to    = trig.trig(k)/freq + trig.parm.Posttrigger_ms/1000;% sec
        trial.onset = trig.trig(k)/freq;                       % sec
        trial_list = [trial_list; trial];
    end
end

% Trigger channel
trig_ch_list = trig.parm.status_ch;

%
% --- After check
%
if nargout ~= 2
    error('Function caller should receive obj.');
end

