function [tag_obj, ix] = vb_tag_util_find_tag(tags, name)
% find tag object by name
% [USAGE]
%    [tag_obj, ix] = vb_tag_util_find_tag(tags, name);
% [IN]
%    tags : tag object list
%    name : tag name
% [OUT]
%    tag_obj : found tag object.
%         ix : Nth tag.
%
% Copyright (C) 2011, ATR All Rights Reserved.
% License : New BSD License(see VBMEG_LICENSE.txt)

%
% --- Previous check
%
if ~exist('tags', 'var') || isempty(tags)
    error('Specified tags are invalid.');
end
if ~exist('name', 'var') || isempty(name) || ~ischar(name)
    error('Specified tag name is invalid');
end

%
% --- Main Procedure
%
tag_obj = [];
ix = [];
for k=1:length(tags)
    tag_name = vb_tag_get_tag_name(tags{k});
    if strcmp(tag_name, name)
        tag_obj = [tag_obj; tags{k}];
        ix = [ix; k];
    end
end
