function [ch_list] = vb_continuous_file_get_ch_list(obj, type)
% return channel name list.
% [USAGE]
%    [ch_list] = continous_file_get_ch_list(obj, type);
% [IN]
%     obj : continous_file object
%    type : Channel type : 'MEG', 'EEG', 'EXTRA'
% [OUT]
%    ch_list : channnel name list.
%
% Copyright (C) 2011, ATR All Rights Reserved.
% License : New BSD License(see VBMEG_LICENSE.txt)

%
% --- Previous check
%
if ~exist('obj', 'var')
    error('obj is a required parameter.');
end
if ~exist('type', 'var')
    error('type is a required parameter.');
end
%
% --- Main Procedure
%
ch_info = vb_load_channel_info(obj.filename, type);
ch_list = ch_info.Name(ch_info.Active == 1);
