function vb_te_channel_selector_callback(data, hObj)
%
% Copyright (C) 2011, ATR All Rights Reserved.
% License : New BSD License(see VBMEG_LICENSE.txt)

H = data.H;

switch(hObj)
    case H.ok_push
        data.cancel_flag = false;
        set(H.figure, 'Visible', 'off');
    case H.cancel_push
        data.cancel_flag = true;
        set(H.figure, 'Visible', 'off');
    case H.figure
        data.cancel_flag = true;
        set(H.figure, 'Visible', 'off');
    case H.channel_selecter_popup
        val = get(hObj, 'Value');
        table_data = cell(get(data.table_h, 'data'));
        if val == 1
        elseif val == 2
            for k=1:size(table_data, 1)
                table_data{k, 2} = true;
            end
            set(data.table_h, 'data', table_data);
        elseif val == 3
            ret = inputdlg('Channel selection step', 'Every N channel', 1);
            if ~isempty(ret) && ~isempty(ret{1})
                step = str2double(ret{1});
                Nch  = size(table_data,1);
                flags = false(Nch, 1);
                flags(1:step:Nch) = true;
                for k=1:Nch
                    table_data{k, 2} = flags(k);
                end
                set(data.table_h, 'data', table_data);
            end
                
        elseif val == 4
            for k=1:size(table_data, 1)
                table_data{k, 2} = false;
            end
            set(data.table_h, 'data', table_data);
        end
end

guidata(H.figure, data);
