function [data] = vb_trial_extractor_show_tag_trial(data)
% Display trial list according to selected tags.
%
% [USAGE]
%    [data] = vb_trial_extractor_show_tag_trial(data);
% [IN]
%    data : vb_trial_extractor object.
% [OUT]
%    data : vb_trial_extractor object.
%
% Copyright (C) 2011, ATR All Rights Reserved.
% License : New BSD License(see VBMEG_LICENSE.txt)

%
% --- Previous check
%
if ~exist('data', 'var')
    error('data is a required parameter.');
end

%
% --- Main Procedure
%
H = data.H;
if isempty(get(H.tag_listbox, 'String'))
    set(H.tag_file_push, 'Enable', 'off');
    set(H.tag_selected_trial_push, 'Enable', 'off');
    set(H.trial_set_listbox, 'String', '');
    set(H.trial_set_listbox, 'Value', 1);
    set(H.preview_push, 'Enable', 'off');
    set(H.trial_select_all_push, 'Enable', 'off');
    return;
end

selected = get(H.tag_listbox, 'Value');
tags_trial_ix = [];
for k=1:length(selected)
    line = selected(k);

    % Get trial index according to tag
    tags_trial_ix = [tags_trial_ix; ...
                     vb_tag_get_trial_index(data.label_list{line})];
end
tags_trial_ix = unique(tags_trial_ix);
trial_set = data.trial_list(tags_trial_ix);
Ntrial = length(trial_set);

trial_list_str = cell(0);
if Ntrial
    % Sort by 'from'
    [tmp, time_ix] = sort([trial_set.from]);

    % Store showing trial index sorted by time
    data.showing_trial_ix = tags_trial_ix(time_ix);
    trial_set = trial_set(time_ix);

    MEGinfo = vb_continuous_file_get_meg_info(data.continuous_file);
    MEGinfo = vb_meginfo_set_pre_trigger(MEGinfo, 0);

    from = vb_index_to_time([trial_set.from], MEGinfo) / 1000;%[msec]->[sec]
      to = vb_index_to_time([trial_set.to], MEGinfo) / 1000;  %[msec]->[sec]
    onset =vb_index_to_time([trial_set.onset], MEGinfo) / 1000;%[msec]->[sec]  
    % show trial list
    for k=1:Ntrial
        trial_list_str{k} = ...
            sprintf('%3d : %.3f - %.3f (onset : %.3f)', k, ...
                     from(k), to(k), onset(k)); % Removed last '\n' by Fukuma 2022/07/14
    end

    % Update button state
    set(H.tag_file_push, 'Enable', 'on');
    set(H.tag_selected_trial_push, 'Enable', 'on');
    set(H.preview_push, 'Enable', 'on');
    set(H.trial_select_all_push, 'Enable', 'on');
end
% Set trial string
set(H.trial_set_listbox, 'String', trial_list_str);
if max(get(H.trial_set_listbox, 'Value')) > Ntrial
    set(H.trial_set_listbox, 'Value', Ntrial);
end
% Update caption
set(H.trial_num_text, 'String', sprintf('Trial list[sec] (number of trials = %d)', size(trial_list_str,2)));

%
% --- After check
%
if nargout ~= 1
    error('function caller should receive vb_trial_extractor object.');
end
