function [data] = vb_trial_extractor_notify_viewer(data, updated_labels)
% updated vb_timeseries_viewer trial data.
% [USAGE]
%    [data] = vb_trial_extractor_notify_viewer(data, updated_labels);
% [IN]
%              data : vb_trial_extractor_object.
%    updated_labels : Changed label name list [cell string]
% [OUT]
%    data : updated vb_trial_extractor object.
%
% Copyright (C) 2011, ATR All Rights Reserved.
% License : New BSD License(see VBMEG_LICENSE.txt)

%
% --- Previous check
%
if ~exist('data', 'var')
    error('data is a required parameter.');
end
if ~exist('updated_labels', 'var')
    error('updated_labels is a required parameter.');
end
if ischar(updated_labels)
    updated_labels = {updated_labels};
end
%
% --- Main Procedure
%

% Check if viewers are alive or not
remove_ix = [];
for k=1:length(data.viewer)
    if ~ishandle(data.viewer{k}.figure)
        % figure is already removed
        remove_ix = [remove_ix, k];
    end
end
% remove unavailable handle of viewers.
if ~isempty(remove_ix)
    data.viewer(remove_ix) = [];
end

% Update viewers
for k=1:length(data.viewer)
    % Check if the viewer has updated label?
    update_flag = false;
    for j=1:length(updated_labels)
        ix = strmatch(updated_labels{j}, data.viewer{k}.labels);
        if ~isempty(ix)
            update_flag = true;
            break;
        end
    end

    if update_flag
        trial_list_sec = [];
        % create trial list
        trial_list = create_trial_list(data.label_list, ...
                                       data.viewer{k}.labels, ...
                                       data.trial_list);
        if ~isempty(trial_list)
            trial_list_sec = vb_trial_extractor_convert_trial_into_sec(data, trial_list);
        end
        % update viewer
        vb_timeseries_viewer_ex_update_trial(data.viewer{k}.figure, ...
                                          trial_list_sec);
    end
end

%
% --- After check
%
if nargout ~= 1
    error('function caller should receive updated vb_trial_extractor object.');
end

function trial_list = create_trial_list(label_list, label_name_list, all_trial)
trial_list = [];
tag_objects = [];

% Find tags
for k=1:length(label_name_list)
    tag_obj = vb_tag_util_find_tag(label_list, label_name_list{k});
    tag_objects = [tag_objects, tag_obj];
end

% Union them into 'temp' tag
tmp_tag_obj = vb_tag_util_union_tag(tag_objects, 'temp', all_trial);

% Get trial list
ix = vb_tag_get_trial_index(tmp_tag_obj);
if ~isempty(ix)
    trial_list = all_trial(ix);
end
