function h = vb_trial_extractor_new()
% Launch trial extractor gui.
% This GUI extract trials from CONTINUOUS MEG/EEG files
% by seeing trigger(external) channel.
%
% [USAGE]
%    h = vb_trial_extractor_new;
% [IN]
%    none
% [OUT]
%    h : figure handle of GUI
% [see also]
%    vb_job_trial_onset
%
% Copyright (C) 2011, ATR All Rights Reserved.
% License : New BSD License(see VBMEG_LICENSE.txt)

% Load figure
h = openfig('vb_trial_extractor.fig');

%
% --- create trigger value input box and set initial value.
%
H = guihandles(h);
% analog
create_trigger_value_box(H.trigger_level_edit, h, 'analog_level_edit', num2str(0.5))
% integer
create_trigger_value_box(H.trigger_level_edit, h, 'integer_level_edit', '00000001');
% bit
create_trigger_value_box(H.trigger_level_edit, h, 'bit_level_edit', '0');
% % emg
% create_trigger_value_box(H.trigger_level_edit, h, 'emg_level_edit', '')
% % voice
% create_trigger_value_box(H.trigger_level_edit, h, 'voice_level_edit', '')

% Initialize member variables
data = vb_trial_extractor_init(h);

data = vb_trial_extractor_update_screen(data);

% store application data
guidata(h, data);


function create_trigger_value_box(base, fig, tag, str)
% Copy template editbox
tmp_h = copyobj(base, fig);
set(tmp_h, 'Parent', get(base, 'Parent'));
set(tmp_h, 'Position', get(base, 'Position'));

% Set value and tag
set(tmp_h, 'Tag', tag);
set(tmp_h, 'Visible', 'off');
set(tmp_h, 'String', str);
