function [trig_obj] = vb_trial_extractor_create_trigger(data)
% Create trigger object from GUI input.
% [USAGE]
%    [trig_obj] = vb_trial_extractor_create_trigger(data);
% [IN]
%    data : vb_trial_extractor object
% [OUT]
%    trig_obj : trigger object.
%
% Copyright (C) 2011, ATR All Rights Reserved.
% License : New BSD License(see VBMEG_LICENSE.txt)

%
% --- Previous check
%
if ~exist('data', 'var')
    error('data is a required parameter.');
end

%
% --- Main Procedure
%

H = data.H;

% get selected trigger channel
ch_name_list = get(H.trigger_channel_listbox, 'String');
ch_name      = ch_name_list(get(H.trigger_channel_listbox, 'Value'));
Nch          = size(ch_name, 1);
% selected slope
slope_selected = get(H.trigger_slope_popup, 'Value');
slope_item     = get(H.trigger_slope_popup, 'String');

% Create trigger
trig_type_list  = get(H.trigger_type_popup, 'String');
trig_type = trig_type_list{get(H.trigger_type_popup, 'Value')};
trig_slope = slope_item{slope_selected};
try
switch(trig_type)
    case 'analog'
        trig_level = str2double(get(H.analog_level_edit, 'String'));
        trig_obj = vb_analog_trigger_new(ch_name, trig_slope, trig_level);
    case 'voice'
        trig_obj = vb_voice_trigger_new(ch_name, ...
                   data.voice_parm.optional_parm.status_level, ...
                   data.voice_parm.optional_parm.t_period, ...
                   data.voice_parm.advanced_parm.p_val, ...
                   data.voice_parm.advanced_parm.t_smooth);
    case 'emg'
        trig_obj = vb_emg_trigger_new(ch_name, ...
                   data.emg_parm.optional_parm.status_level, ...
                   data.emg_parm.optional_parm.t_event, ...
                   data.emg_parm.advanced_parm.t_smooth, ...
                   data.emg_parm.optional_parm.t_period, ...
                   data.emg_parm.advanced_parm.p_val);
    case 'integer'
        bitpattern = get(H.integer_level_edit, 'String');
        offset  = data.trigger_adjust_parameter.Data_offset;
        bitmask = data.trigger_adjust_parameter.Bitmask;
        trig_obj = vb_integer_trigger_new(ch_name, trig_slope, bitpattern, bitmask, offset);
    case 'bit'
        bit_number = uint32(str2double(get(H.bit_level_edit, 'String')));
        offset  = data.trigger_adjust_parameter.Data_offset;
        bitmask = data.trigger_adjust_parameter.Bitmask;
        trig_obj = vb_bit_trigger_new(ch_name, trig_slope, bit_number, bitmask, offset);
    case 'multi channel pattern'
        table_ix = [];
        for k=1:Nch
            table_ix = [table_ix; strmatch(ch_name{k}, data.multi_channel_pattern(:, 1), 'exact')];
        end
        channel_pattern = [data.multi_channel_pattern{table_ix, 2}];
        trig_obj = vb_multi_trigger_new(ch_name, trig_slope, channel_pattern);
end
catch
    [msg, msg_f] = vb_get_error_msg(lasterror);
    errordlg(msg_f, 'Trigger information');
    return;
end

