function [trial_list_sec] = vb_trial_extractor_convert_trial_into_sec(data, trial_list)
% convert trial_list into sec.
% [USAGE]
%    [trial_list_sec] = vb_trial_extractor_convert_trial_into_sec(data, trial_list);
% [IN]
%          data : vb_trial_extractor object.
%    trial_list : trial list. unit:sample number.
%                 trial_list(N).from
%                              .to
%                              .onset
% [OUT]
%    trial_list_sec : trial_list. unit:second.
%
% Copyright (C) 2011, ATR All Rights Reserved.
% License : New BSD License(see VBMEG_LICENSE.txt)

%
% --- Previous check
%
if ~exist('data', 'var')
    error('data is a required parameter.');
end
if ~exist('trial_list', 'var')
    error('trial_list is a required parameter.');
end

%
% --- Main Procedure
%
MEGinfo = vb_continuous_file_get_meg_info(data.continuous_file);
MEGinfo = vb_meginfo_set_pre_trigger(MEGinfo, 0);

Ntrial = length(trial_list);

trial_list_sec = [];
if Ntrial
    from = vb_index_to_time([trial_list.from], MEGinfo) / 1000; %[msec]->[sec]
      to = vb_index_to_time([trial_list.to], MEGinfo) / 1000;   %[msec]->[sec]
    onset= vb_index_to_time([trial_list.onset], MEGinfo) / 1000; %[msec]->[sec]

    for k=1:Ntrial
        % create trial_sec struct
        trial_sec = struct;
        trial_sec.from = from(k);
        trial_sec.to   = to(k);
        trial_sec.onset= onset(k);
        % trial list [sec]
        trial_list_sec = [trial_list_sec; trial_sec];
    end
end
