function [data] = vb_trial_extractor_add_trial(data)
% Add new trial.
% [USAGE]
%    [data] = vb_trial_extractor_add_trial(data);
% [IN]
%    data : vb_trial_extractor object.
% [OUT]
%    data : updated vb_trial_extractor object.
%
% Copyright (C) 2011, ATR All Rights Reserved.
% License : New BSD License(see VBMEG_LICENSE.txt)

%
% --- Previous check
%
if ~exist('data', 'var')
    error('data is a required parameter.');
end

%
% --- Main Procedure
%
H = data.H;

% Sample Frequency [Hz]
freq = vb_continuous_file_get_sample_freq(data.continuous_file);
[Nsample] = vb_continuous_file_get_Nsample(data.continuous_file);

% Sample number for Pre/Post period
pretrigger  = ceil(data.trial_setting.pretrigger_ms  *(freq/1000));
posttrigger = ceil(data.trial_setting.posttrigger_ms *(freq/1000));

err = true;
while(err)
    onset_time_sec = inputdlg('Input trial onset time [sec]', 'Add trial');
    if isempty(onset_time_sec), return; end
    if isnan(str2double(onset_time_sec))
        h = errordlg('Input value is not a number.', 'Add trial');
        waitfor(h);
        continue; % back to top of while
    end

    % calc sampling number
    onset_time       = round(str2double(onset_time_sec{1}) * freq)+1; % 0[sec] = sample:1
    pretrigger_time  = onset_time - pretrigger;
    posttrigger_time = onset_time + posttrigger - 1;

    if pretrigger_time <= 0
        h = errordlg('Cant''t specify the onset time because pretrigger position is less than 0.', 'Add trial');
        waitfor(h);
        continue; % back to top of while
    elseif posttrigger_time > Nsample
        h = errordlg('Can''t specify the onset time because posttrigger position is larger than data length.', 'Add trial');
        waitfor(h);
        continue; % back to top of while
    end
    err = false; % normal exit
end

% Create trial and add list
trial_obj = vb_trial_new(pretrigger_time, posttrigger_time, onset_time);
data.trial_list = [data.trial_list; trial_obj];
new_ix = length(data.trial_list);

%
% --- Add created trial to selected label
%

% multiple selection is prohibited by listbox
labels   = get(H.tag_listbox, 'String');
selected = get(H.tag_listbox, 'Value');
selected_label = labels{selected};

% add trial to selected label
[tag_obj, nth] = vb_tag_util_find_tag(data.label_list, selected_label);
if ~isempty(tag_obj)
    data.label_list{nth} = vb_tag_add_trial_index(data.label_list{nth}, new_ix);
    % Update viewer if a viewer is opened.
    data = vb_trial_extractor_notify_viewer(data, selected_label);
end

%
% --- After check
%
if nargout ~= 1
    error('function caller should receive this object.');
end
