function parm = vb_signal_processor_util_convert_editor_to_parm(editor_item, parm_type)
% Convert editor_item(for vb_input_settings) to parameter.
% [USAGE]
%    parm = vb_signal_processor_util_convert_editor_to_parm(...
%                                                 editor_item, ...
%                                                 parm_type);
%   
% [IN]
%    editor_item : data for editor(vb_input_settings) which contains parameter.
%      parm_type : parameter type.
% [OUT]
%    parm : parameter extracted from editor_item.
%
% Copyright (C) 2011, ATR All Rights Reserved.
% License : New BSD License(see VBMEG_LICENSE.txt)

%
% --- Previous check
%
if ~exist('editor_item', 'var')
    error('editor_item is a required parameter.');
end
if ~exist('parm_type', 'var')
    error('parm_type is a required parameter.');
end

%
% --- Main Procedure
%
parm = struct;
parm.type = parm_type;

d = vb_define_signal_processor;

parm=struct;
parm.type=parm_type;

d = vb_define_signal_processor;

for k=1:length(editor_item)
    item  = editor_item{k};
    prop  = vb_input_settings_get_prop(item, 'title');
    value = vb_input_settings_get_prop(item, 'value');
    switch(parm_type)
        case d.TYPE_PROCESSING_BIAS_CORRECTION
             if strcmpi(prop, 'mode')
                 parm.mode = str2num(value);
             else
                 error('Unknown field.');
             end
        case {d.TYPE_PROCESSING_HIGHPASS, d.TYPE_PROCESSING_LOWPASS}
             if strcmpi(prop, 'Cutoff frequency [Hz]')
                 parm.cutoff_freq = str2num(value);
             elseif strcmpi(prop, 'Impulse response')
                 parm.impulse_response = str2num(value);
             elseif strcmpi(prop, 'Filter order')
                 parm.order = str2num(value);
             elseif strcmpi(prop, 'Time delay correction')
                 parm.filtfilt = str2num(value);
             else
                 error('Unknown field.');
             end
        case {d.TYPE_PROCESSING_BANDPASS, d.TYPE_PROCESSING_STOPBAND}
            if strcmpi(prop, 'Lower cutoff frequency [Hz]')
                parm.cutoff_freq_low = str2num(value);
            elseif strcmpi(prop, 'Impulse response')
                parm.impulse_response = str2num(value);
            elseif strcmpi(prop, 'Higher cutoff frequency [Hz]')
                parm.cutoff_freq_high = str2num(value);
            elseif strcmpi(prop, 'Filter order')
                parm.order = str2num(value);
            elseif strcmpi(prop, 'Time delay correction')
                parm.filtfilt = str2num(value);
            else
                error('Unknown field.');
            end
        case d.TYPE_PROCESSING_DOWNSAMPLE
            if strcmpi(prop, 'New sampling frequency [Hz]')
                parm.dsamp_freq = str2num(value);
            else
               error('Unknown field.');
            end
        case d.TYPE_PROCESSING_COMMON_REFERENCE
            if strcmpi(prop, 'mode')
                parm.mode = str2num(value);
            else
                error('Unknown field.');
            end
            
        otherwise
            error('Unkonwn parmeter type was specified.');
    end
end
