function data = vb_signal_processor_remove_parm_from_processlist(data, nth)
% Remove processing tool from processinglist.
% [USAGE]
%    data = vb_signal_processor_remove_parm_from_processlist(data, nth);
% [IN]
%   data : Application data.
%    nth : Nth item in processlist.
% [OUT]
%    data : Updated application data.
%
% Copyright (C) 2011, ATR All Rights Reserved.
% License : New BSD License(see VBMEG_LICENSE.txt)

%
% --- Previous check
%
if ~exist('data', 'var')
    error('data is a required parameter.');
end
if ~exist('nth', 'var')
    error('nth is a required parameter.');
end

%
% --- Main Procedure
%
Ntool = length(data.process_list);
if Ntool < nth
    error('Inconsistent data status (processing list and selected item).');
end

% Remove
data.process_list(nth) = [];

%
% --- After check
%
if nargout ~= 1
    error('function caller should receive data object.');
end
