function [parm] = vb_signal_processor_get_default_parm(process_type)
% return default parameter for specified processing type.
% [USAGE]
%    [parm] = vb_signal_processor_get_default_parm(process_type);
% [IN]
%    process_type : processing type
% [OUT]
%    parm : default parameter for specified process_type.
%
% Copyright (C) 2011, ATR All Rights Reserved.
% License : New BSD License(see VBMEG_LICENSE.txt)

%
% --- Previous check
%
if ~exist('process_type', 'var') || ~ischar(process_type)
    error('Invalid process_type was specified.');
end

%
% --- Main Procedure
%
d = vb_define_signal_processor;
switch(process_type)
    case d.TYPE_PROCESSING_BIAS_CORRECTION
        parm = d.bias_correction_parm;
    case d.TYPE_PROCESSING_HIGHPASS
        parm = d.highpass_parm;
    case d.TYPE_PROCESSING_LOWPASS
        parm = d.lowpass_parm;
    case d.TYPE_PROCESSING_BANDPASS
        parm = d.bandpass_parm;
    case d.TYPE_PROCESSING_STOPBAND
        parm = d.stopband_parm;
    case d.TYPE_PROCESSING_DOWNSAMPLE
        parm = d.down_sample_parm;
    case d.TYPE_PROCESSING_COMMON_REFERENCE
        parm = d.common_ref_parm;
    otherwise
        error('Unkonwn process_type was specified.');
end
