function vb_signal_processor_batch_exec(proc_parm, mode)
% run batch signal processing.
% [USAGE]
%    vb_signal_processor_batch_exec(proc_parm, mode);
% [IN]
%    proc_parm : batch parameter.
%         mode : confirmation for overwrite, create directory.
%                = 0 : interactive mode by commandline [default]
%                = 1 : interactive mode by GUI
%                = 2 : non-interactive mode
%                      (overwrite = Yes to All, create directory = Yes)
%
% Copyright (C) 2011, ATR All Rights Reserved.
% License : New BSD License(see VBMEG_LICENSE.txt)

%
% --- Previous check
%
if ~exist('proc_parm', 'var')
    error('proc_parm is a required parameter.');
end
if ~exist('mode', 'var')
    mode = 0;
end
if ~(mode == 0 || mode == 1 || mode == 2)
    error('Unknown mode was specified.');
end

%
% --- Main Procedure
%

% Making directory for output
is_ready = vb_signal_processor_confirm_output_dir(proc_parm, mode);
if is_ready == false
    msg = 'Processing was canceled.';
    if mode == 1
        waitfor(msgbox(msg, 'Notice'));
        return;
    elseif mode == 0 || mode == 2
        vb_disp(msg);
        return;
    end
end

% Overwrite check
output_ix = vb_signal_processor_confirm_overwrite_files(proc_parm, mode);
if ~isempty(output_ix)
    input_files  = proc_parm.input_files(output_ix);
    output_files = proc_parm.output_files(output_ix);

    vb_signal_processor_apply_processing(input_files, ...
                                         output_files, ...
                                         proc_parm.process_list, ...
                                         mode);
    end
end

