function head_file = pa_headfile_name(proj_root, head_parm)
% get head file name.
% [Usage]
%    pa_headfile_name(proj_root, head_parm);
% [Input]
%    proj_root : project root directory.
%    head_parm : head parm for vb_job_head_3shell.
% [Output]
%    head_file : head file name(.head.mat)

%
% --- Previous check
%
if nargin ~= 2
    error('Please check function usage.');
end

%
% --- Main Procedure
%
head_file = fullfile(proj_root, head_parm.head_file);
if head_parm.Nsurf == 1
    head_file = [head_file, '_CSF_', num2str(head_parm.Nvertex), '.head.mat'];
elseif head_parm.Nsurf == 3
    head_file = [head_file, '_3shell_', num2str(head_parm.Nvertex*head_parm.Nsurf), '.head.mat'];
else
    error('Head model is 1shell or 3shell');
end

